---
name: asian-meal-prep-brainstorm
version: 1.0.0
---

# Initialization

Asian Meal Prep Brainstorm is an AI skill designed to help users plan, organize, and execute efficient meal preparation sessions focused on authentic Asian cuisines. This skill transforms meal prepping from a daunting, time-consuming task into a systematic, repeatable process using the meal matrix framework.

## What This Skill Does

- Plans component-based meal prep sessions for 8+ Asian cuisines (Thai, Korean, Japanese, Chinese, Vietnamese, Filipino, Indian, Indonesian)
- Uses the Meal Matrix system (Protein + Carbs + Vegetables + Sauces) to generate unlimited meal combinations
- Provides cuisine-specific batch cooking techniques and sauce recipes
- Creates detailed prep schedules optimized for available time
- Ensures food safety compliance with USDA standards
- Optimizes grocery budgets by maximizing ingredient overlap

## Structure

- `SKILL.md` - Main skill prompt with complete instructions

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r asian-meal-prep-brainstorm/ ~/.claude/skills/asian-meal-prep-brainstorm/
```

### ChatGPT / Custom GPT
1. Create a new Custom GPT
2. Paste the contents of `SKILL.md` (everything after the frontmatter) into the Instructions field
3. Set the name to "Asian Meal Prep Brainstorm"

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter section
3. Paste into your AI assistant as a system prompt or custom instruction

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{primary_cuisine}}` | `Thai` | Main Asian cuisine to focus on (Thai, Korean, Japanese, Chinese, Vietnamese, Filipino, Indian, Indonesian) |
| `{{prep_time_available}}` | `180` | Total minutes available for meal prep session |
| `{{serving_count}}` | `5` | Number of servings to prepare per meal (typically 5-7 for a week) |
| `{{dietary_restrictions}}` | `none` | Dietary constraints (vegetarian, vegan, gluten-free, dairy-free, nut-free) |
| `{{protein_preference}}` | `chicken` | Primary protein for the week (chicken, beef, pork, tofu, fish, shrimp, eggs) |
| `{{spice_tolerance}}` | `medium` | Heat tolerance level (mild, medium, hot) |
| `{{storage_capacity}}` | `standard` | Available refrigerator/freezer space (standard, limited, extensive) |

## Example Usage

**Basic Thai Meal Prep:**
```
I have 3 hours this Sunday to meal prep. I want to eat Thai food all week. 
I can eat chicken, and my spice tolerance is medium. Can you brainstorm 
a simple Thai meal prep plan with 5 servings each?
```

**Cross-Cuisine Planning:**
```
I want to meal prep for 7 days using Korean and Japanese cuisines. I have 
a 4-hour window on Sunday and a good-sized freezer. I eat everything 
except shellfish, and I have a high spice tolerance.
```

**Budget-Conscious:**
```
I work full-time and can only prep on weeknights (maybe 1.5 hours Wed + 1 hour Sun). 
I want Chinese meal prep because it's cheap. Super tight budget—under $30 for 
5 dinners. Show me the cheapest proteins and how to make them taste different 
using simple sauces.
```

## Key Concepts

- **Meal Matrix**: Four-column planning tool (Protein, Carbs, Vegetables, Sauces) for mix-and-match meal combinations
- **Component Prep**: Preparing individual ingredients separately for maximum flexibility
- **Batch Cooking**: Preparing multiple portions in one session for the week
- **Sauce Variation**: Using different sauces to transform the same base ingredients into distinct meals
- **Mise en Place**: Organizing all ingredients before cooking for efficient workflow

---
Downloaded from [Find Skill.ai](https://findskill.ai)
