---
name: app-subscription-terminator
version: 1.0.0
---

# Initialization

App & Subscription Terminator - A comprehensive skill for systematically auditing digital accounts, creating provider-specific cancellation plans, backing up data before deletion, and establishing recovery procedures.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete instructions for account termination

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r app-subscription-terminator/ ~/.claude/skills/app-subscription-terminator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{audit_scope}}` | `personal` | Scope of the audit (personal, team, enterprise) |
| `{{recovery_window_days}}` | `30` | Days to attempt recovery after cancellation |
| `{{data_backup_required}}` | `true` | Mandate data export before termination |
| `{{compliance_framework}}` | `general` | Regulatory framework (general, gdpr, ccpa, hipaa, sox) |
| `{{cancellation_method_priority}}` | `self_service` | Preferred cancellation route |
| `{{data_retention_months}}` | `6` | Months to retain exported data |

## Key Features

### Account Discovery
- Email search techniques for finding forgotten accounts
- Password manager export and analysis
- Financial statement review for recurring charges
- OAuth/social login audit across major platforms
- Browser saved password consolidation

### Risk Assessment
- Data sensitivity scoring (1-5)
- Breach exposure evaluation
- Access scope analysis
- Activity level categorization
- Prioritization matrix generation

### Cancellation Procedures
- Provider-specific cancellation paths
- Dark pattern bypass techniques
- Difficulty ratings (Easy/Medium/Hard/Roach Motel)
- Common provider procedures (Netflix, Amazon, Spotify, Adobe, etc.)

### Data Backup
- Pre-termination backup protocol
- Platform-specific export URLs
- Verification checklist
- Secure storage recommendations

### Recovery Procedures
- Recovery window reference by service
- Self-service recovery steps
- Support contact protocols
- Identity verification guidance

### Compliance Documentation
- Audit trail templates
- GDPR deletion request templates
- Enterprise offboarding checklists
- Regulatory framework support

## Workflows Included

1. **Personal Spring Cleaning** (2-4 hours)
   - Discovery, categorization, backup, termination, verification

2. **Enterprise SaaS Audit** (1-2 weeks)
   - Automated discovery, inventory analysis, redundancy detection, contract review

3. **Account Recovery After Mistake** (Minutes to hours)
   - Assessment, self-service recovery, support contact, data restoration

## Example Usage

```
I probably have 100+ forgotten accounts from the past decade. I'm worried
about security from abandoned accounts with old passwords. Can you help me
audit all my accounts, figure out which ones to close, and safely cancel them?
I want to prioritize accounts that have financial access or personal data.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
