---
name: subscription-murder-list
version: 1.0.0
---

# Subscription Murder List - Initialization

Scan bank statements, emails, and transaction histories to detect forgotten subscriptions, identify hidden recurring charges, and systematically eliminate wasteful spending that costs the average person $200-400 annually.

## What This Skill Does

The Subscription Murder List skill transforms your AI assistant into a ruthless subscription detective that:

1. **Detects Hidden Subscriptions** - Analyzes bank statements and transaction histories to find recurring charges you've forgotten about
2. **Parses Email Receipts** - Scans email inbox for subscription confirmations, renewal notices, and trial conversions
3. **Calculates Waste Scores** - Identifies which subscriptions provide low value relative to their cost
4. **Tracks Free Trials** - Prevents trial-to-paid conversions with timely cancellation reminders
5. **Detects Price Increases** - Alerts you when services raise prices and provides negotiation scripts
6. **Generates Murder Lists** - Creates prioritized lists of subscriptions to cancel for maximum savings

## Structure

```
subscription-murder-list/
├── SKILL.md   - Main skill prompt (paste into AI assistant)
└── INIT.md    - This file (setup instructions)
```

## Files to Generate

None - this is a prompt-only skill. All functionality is contained in SKILL.md.

## Installation Instructions

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r subscription-murder-list/ ~/.claude/skills/subscription-murder-list/

# The skill will be available in your next Claude Code session
```

### Claude.ai / ChatGPT / Gemini / Copilot

1. Open `SKILL.md` in a text editor
2. Copy all content after the `---` frontmatter delimiter
3. Paste into a new conversation with your AI assistant
4. The AI will now operate as a Subscription Murder List specialist

### Custom Instructions (ChatGPT)

1. Go to Settings → Personalization → Custom Instructions
2. In "How would you like ChatGPT to respond?" paste the SKILL.md content
3. Save - the skill will persist across conversations

## Variables

Customize these parameters to adjust detection behavior:

| Variable | Default | Description |
|----------|---------|-------------|
| `subscription_min_amount` | `$0.99` | Minimum charge to flag as subscription |
| `subscription_max_amount` | `$200` | Maximum charge to consider (excludes rent) |
| `min_recurrence_months` | `2` | Months of consistency required |
| `date_tolerance_days` | `3` | Variance allowed in billing date |
| `amount_tolerance_fixed` | `5%` | Variance for fixed-rate subscriptions |
| `amount_tolerance_variable` | `20%` | Variance for usage-based subscriptions |
| `inactivity_threshold_days` | `60` | Days of non-use before flagging |
| `renewal_reminder_days` | `7` | Days before renewal to alert |

## Quick Start Examples

### Bank Statement Analysis
```
I'm uploading my Chase bank statement PDF for the last 3 months.
Find all my hidden subscriptions and create a murder list prioritized
by waste potential.
```

### Email Discovery
```
Scan my email for subscription-related messages from the past year.
Find any services I'm paying for that I might have forgotten about.
```

### Trial Tracking
```
I just signed up for these free trials:
- Hulu (7-day trial, ends Oct 25)
- Canva Pro (30-day trial, ends Nov 15)
- Notion (14-day trial, ends Oct 30)

Track these and remind me before they convert to paid.
```

### Unused Cleanup
```
Here are my current subscriptions with my usage estimates:
- Netflix $15.99/mo - watch weekly
- Gym $50/mo - haven't gone in 3 months
- Adobe CC $54.99/mo - used Photoshop once last month
- Spotify $11.99/mo - daily
- Dropbox $9.99/mo - using 2GB of 2TB

Which ones should I cancel?
```

## Expected Output

The skill produces structured reports including:

- **Murder List Summary** - Total spend, subscription count, savings potential
- **High-Priority Targets** - Subscriptions with highest waste scores
- **Confidence Ratings** - How certain the detection is for each subscription
- **Cancellation Instructions** - Direct links and step-by-step guides
- **Trial Warnings** - Upcoming conversions requiring action
- **Price Increase Alerts** - Services that raised rates + negotiation scripts

## Key Features

### Pattern Detection
- Weekly, monthly, quarterly, semi-annual, annual billing cycles
- ±3 day tolerance for monthly, ±1 day for weekly
- ±5% amount tolerance for fixed, ±20% for usage-based

### False Positive Filtering
- Excludes restaurants, parking, transit, grocery
- Merchant name normalization (SPOTIFY AB → Spotify)
- Configurable whitelist for frequently-visited merchants

### Privacy-First Design
- Accepts CSV upload instead of bank account linking
- Email forwarding alternative to inbox access
- Local processing where possible
- No data retention beyond analysis session

## Troubleshooting

**No subscriptions detected?**
- Ensure 3+ months of transaction history
- Check file format (PDF or CSV)
- Expand amount range if subscriptions are outside $0.99-$200

**Too many false positives?**
- Add frequent merchants to exclusion list
- Tighten tolerances (±2% instead of ±5%)
- Require 3/3 months match instead of 2/3

**Missing known subscription?**
- Check for merchant name variations
- Verify billing date falls within analysis period
- Manually add if detection fails

## Related Skills

- **Subscription Audit Automator** - Broader management with negotiation
- **Budget Planner** - Comprehensive budgeting after cleanup
- **Expense Categorizer** - Categorize all spending including subscriptions
- **Debt Elimination Sequencer** - Redirect savings to debt payoff

---
Downloaded from [Find Skill.ai](https://findskill.ai)
