---
name: investment-portfolio-analyzer
version: 1.0.0
---

# Investment Portfolio Analyzer - Initialization

An intelligent portfolio analysis tool that evaluates asset allocation, calculates performance metrics (Sharpe ratio, drawdowns), identifies rebalancing opportunities, and optimizes tax efficiency for individual investors.

## Package Contents

```
investment-portfolio-analyzer/
├── SKILL.md          # Main skill prompt (portfolio analysis instructions)
└── INIT.md           # This initialization file
```

## What This Skill Does

1. **Analyzes Asset Allocation** - Compares current holdings to target allocation
2. **Calculates Performance Metrics** - Sharpe ratio, Treynor ratio, volatility, drawdowns
3. **Generates Rebalancing Recommendations** - Specific buy/sell instructions
4. **Optimizes Tax Efficiency** - Identifies tax-loss harvesting opportunities
5. **Assesses Risk** - Concentration analysis, correlation matrix
6. **Stress Tests Portfolios** - Market crash and inflation scenarios
7. **Compares to Benchmarks** - Performance attribution analysis

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r investment-portfolio-analyzer/ ~/.claude/skills/investment-portfolio-analyzer/

# Or add to project-specific skills
cp -r investment-portfolio-analyzer/ .claude/skills/investment-portfolio-analyzer/
```

Then invoke with: `/investment-portfolio-analyzer`

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md` in this package
2. Copy all content after the `---` frontmatter delimiter
3. Paste into your AI assistant as the system prompt or initial context
4. Begin your conversation with your portfolio details

## Variables

Customize these parameters for your situation:

| Variable | Default | Description |
|----------|---------|-------------|
| `target_allocation` | `{"stocks": 0.60, "bonds": 0.30, "cash": 0.10}` | Your desired allocation by asset class |
| `rebalancing_strategy` | `threshold_based` | Strategy: calendar_based, threshold_based, volatility_based, tax_conscious |
| `tolerance_band_pct` | `5` | Percentage drift threshold for rebalancing triggers |
| `tax_rate_capital_gains` | `0.20` | Your capital gains tax rate for tax calculations |
| `risk_free_rate` | `0.05` | Current T-bill rate for Sharpe ratio calculation |
| `lookback_period_days` | `252` | Historical period (trading days) for volatility metrics |

## Example Usage

```
I have a portfolio with:
- $85K in VOO (S&P 500)
- $35K in VXUS (International)
- $45K in BND (Bonds)
- $15K in VNQ (REITs)

My target is 50% US stocks, 20% international, 20% bonds, 10% REITs.
The S&P returned 28% this year.

Should I rebalance? I'm in the 24% tax bracket and want to minimize capital gains.
Also calculate my Sharpe ratio and check for concentration risks.
```

## Key Features

### Rebalancing Strategies Supported

1. **Calendar-Based** - Rebalance on fixed schedule (annual/quarterly)
2. **Threshold-Based** - Rebalance when allocations drift beyond tolerance bands
3. **Tax-Conscious** - Prioritize tax-efficient moves (harvest losses first)
4. **Volatility-Based** - Adjust frequency based on market volatility

### Performance Metrics Calculated

- **Sharpe Ratio** - Risk-adjusted returns
- **Treynor Ratio** - Returns per unit of systematic risk
- **Maximum Drawdown** - Largest peak-to-trough decline
- **Standard Deviation** - Portfolio volatility
- **Alpha/Beta** - Benchmark-relative performance

### Risk Analysis Provided

- Position concentration analysis
- Sector exposure breakdown
- Correlation matrix between holdings
- Stress testing (crash scenarios, inflation surges)

## Important Disclaimer

This skill provides educational portfolio analysis only. It does not constitute personalized financial advice. Investment decisions involve risk of loss. Always consult a licensed financial advisor before making investment decisions.

## Related Skills

- **Investment Analyzer** - Analyze individual stocks and ETFs
- **Retirement Planner** - Calculate retirement savings goals
- **Financial Independence Calculator** - FIRE number and timeline modeling
- **Net Worth Tracker** - Track total financial position

---
Downloaded from [Find Skill.ai](https://findskill.ai)
