---
name: impulse-buy-interrogator
version: 1.0.0
---

# Impulse Buy Interrogator - Initialization

A financial mindfulness skill that creates deliberate friction between purchase impulses and transactions using probing questions, time-cost analysis, HALT emotional checks, and the 5-Question Gauntlet to prevent buyer's remorse.

## Quick Start

This is a prompt-only skill. Copy the contents of `SKILL.md` into your AI assistant of choice.

## Structure

```
impulse-buy-interrogator/
├── SKILL.md    # Main skill prompt (copy this)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a self-contained prompt skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Create skills directory if it doesn't exist
mkdir -p ~/.claude/skills/impulse-buy-interrogator

# Copy skill files
cp -r impulse-buy-interrogator/ ~/.claude/skills/
```

Then reference in your Claude configuration or paste directly into a conversation.

### ChatGPT / Custom GPTs

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT's system instructions or a Custom GPT configuration

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the full prompt content
3. Paste at the start of your conversation or into system settings

## Variables

Customize these values before use:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{spending_threshold}}` | `50` | Dollar amount that triggers full interrogation mode |
| `{{hourly_wage}}` | `25` | Your hourly wage for calculating time-cost of purchases |
| `{{wait_period_hours}}` | `24` | Mandatory cooling-off period before approving purchases |
| `{{financial_goal}}` | `Emergency Fund` | What you're saving for (used as motivational anchor) |
| `{{currency_symbol}}` | `$` | Currency symbol for all calculations |

### Variable Customization Examples

**For a higher earner with larger threshold:**
```
spending_threshold: 200
hourly_wage: 75
wait_period_hours: 48
financial_goal: Down Payment
currency_symbol: $
```

**For someone in the UK saving aggressively:**
```
spending_threshold: 30
hourly_wage: 15
wait_period_hours: 72
financial_goal: Travel Fund
currency_symbol: £
```

## Core Protocols

The skill includes three main interrogation protocols:

1. **Cool Down Protocol** - For FOMO/urgency situations
   - Time-cost calculation
   - HALT emotional check
   - Mandatory wait period

2. **5-Question Gauntlet** - For on-the-fence purchases
   - Redundancy check
   - Need vs Want distinction
   - Storage test
   - Cost per use calculation
   - Stranger test

3. **Closet Shop Alternative** - For category browsing
   - Physical inventory challenge
   - Insufficiency question
   - Repair/repurpose option

## Example Usage

Start a conversation with:

```
"I'm looking at this $200 blender on Amazon. It's on sale for 20% off and I feel like I need to grab it before the deal expires. Run the interrogation on me."
```

Or:

```
"I want to buy new running shoes. Help me decide if I actually need them."
```

Or:

```
"I've been eyeing a $350 3D printer. It looks cool but I've never done 3D printing before. Should I buy it?"
```

## Key Concepts Used

- **Time-Cost**: Converting purchase price to hours of work
- **HALT Check**: Hungry, Angry, Lonely, Tired emotional assessment
- **Cost Per Use**: Price divided by projected annual uses
- **Stranger Test**: Cash vs item mental exercise
- **Hedonic Adaptation**: Understanding that purchase excitement fades
- **Burden of Ownership**: Full lifecycle cost (acquisition, maintenance, disposal)
- **Opportunity Cost**: What else the money could become

## Best Practices

1. **Be honest** - The skill relies on truthful self-assessment
2. **Delay is the goal** - Any pause before buying is a win
3. **No shame** - The tone is firm but supportive
4. **Track decisions** - Use the Purchase Pause Log for accountability
5. **Separate browsing from buying** - Don't do both in the same session

## Related Skills

- **Spending Guilt Eliminator** - Process post-purchase guilt
- **Money Anxiety Decoder** - Address underlying anxiety patterns
- **Budget Planner** - Create spending frameworks
- **Financial Stress Cycle Breaker** - Break stress-spend-guilt loops

## Troubleshooting

**Skill feels too aggressive:**
- Increase `spending_threshold` to trigger less often
- Reduce `wait_period_hours` for shorter delays

**Not triggering when needed:**
- Lower `spending_threshold` to catch smaller purchases
- Manually invoke with "run the interrogation"

**Time-cost feels off:**
- Update `hourly_wage` to reflect actual take-home rate
- Consider using after-tax hourly rate for accuracy

---
Downloaded from [Find Skill.ai](https://findskill.ai)
