---
name: girl-math-translator
version: 1.0.0
---

# Girl Math Translator - Initialization

Convert spending rationalizations into honest budget impact analysis. This skill translates Girl Math statements—like "It's 50% off so I'm saving $100!"—into factual financial reality without judgment or shame.

## Structure

```
girl-math-translator/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### Claude Code (Recommended)

```bash
# Copy to Claude skills directory
cp -r girl-math-translator/ ~/.claude/skills/girl-math-translator/

# Add to .claude/settings.json under "skills" array
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the `---` frontmatter
3. Create a new Custom GPT or paste into Custom Instructions
4. Set conversation starter: "Analyze this purchase for Girl Math"

### Gemini

1. Open `SKILL.md`
2. Copy the content after frontmatter
3. Paste as system prompt in Gemini Advanced

### Other AI Assistants

1. Open `SKILL.md`
2. Copy everything after the frontmatter (the `---` section)
3. Paste into your AI assistant's system prompt or instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{original_price}}` | `100` | Full retail price before discount |
| `{{discount_percent}}` | `40` | Percentage discount being offered |
| `{{monthly_budget}}` | `2500` | Your total monthly budget |
| `{{financial_goal}}` | `emergency_fund` | Primary goal type |
| `{{goal_target}}` | `5000` | Target amount for goal |
| `{{estimated_uses}}` | `50` | Realistic usage count |

## Quick Start Examples

### Single Purchase Analysis
```
User: "This $200 coat is 50% off - I'm saving $100!"

AI: GIRL MATH STATEMENT: "$100 savings on coat"
    REALITY: You're spending $100, not saving $100
    ACTUAL IMPACT: -$100 from budget
    RECOMMENDATION: Only buy if you'd pay $100 for this coat anyway
```

### Pattern Analysis
```
User: "Here are my last 5 'deal' purchases: [list]"

AI: [Analyzes cumulative impact, projects annual spending]
```

### Cost-Per-Use Check
```
User: "This $300 item will last forever at $0.50 per use!"

AI: [Reality-checks usage estimates with industry data]
```

## Core Capabilities

1. **Translation Engine** - Convert Girl Math to financial reality
2. **Budget Impact Calculator** - Show actual cost vs. perceived savings
3. **Opportunity Cost Analyzer** - What else could this money do?
4. **Cost-Per-Use Reality Check** - Honest usage projections
5. **Pattern Detection** - Spot recurring spending behaviors
6. **Cumulative Impact Tracker** - Project monthly/annual/decade effects
7. **Non-Judgmental Coaching** - Educate without shame

## Key Girl Math Patterns Detected

| Pattern | Example | Translation |
|---------|---------|-------------|
| Discount-as-Income | "I saved $80!" | "I spent $120" |
| Cost-Per-Use Fantasy | "$0.50 per wear!" | "$5+ per wear (realistic)" |
| Cash Illusion | "Cash doesn't count" | "All money is real money" |
| Budget Justification | "Already budgeted $200" | "Could keep the $200" |
| Return-as-Income | "Returned = free money" | "Back to zero, not +$75" |
| Sunk Cost Trap | "Already spent $100..." | "Past is irrelevant" |

## Troubleshooting

### "The AI is being too harsh"
Ensure you copied the full skill content including the tone guidelines. The skill should be educational, not judgmental.

### "Calculations seem off"
Provide specific numbers: original price, discount %, your monthly budget. Estimates produce less accurate analysis.

### "I want to see annual impact"
Ask: "Show me the pattern analysis" or "What does this cost me annually?"

## Related Skills

- **Spending Guilt Eliminator** - Healthy money mindset
- **Money Anxiety Decoder** - Financial anxiety patterns
- **Budget Planner** - Create and track budgets
- **Permission to Spend Framework** - Guilt-free spending
- **Financial Stress Cycle Breaker** - Break anxiety-spending loops

---
Downloaded from [Find Skill.ai](https://findskill.ai)
