---
name: burnout-sabbatical-planner
version: 1.0.0
---

# Burnout Sabbatical Planner - Initialization

Calculate exactly how much money you need for a 3-month career break. This skill helps burned-out professionals determine savings targets, navigate health insurance options (COBRA, ACA, spouse's plan), and optimize taxes during their low-income sabbatical year.

## Structure

```
burnout-sabbatical-planner/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r burnout-sabbatical-planner/ ~/.claude/skills/burnout-sabbatical-planner/
```

### ChatGPT / Gemini / Copilot / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or conversation starter
4. Begin by providing your financial situation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{monthly_rent_mortgage}}` | `2000` | Monthly housing cost (rent, mortgage, property tax, HOA) |
| `{{annual_salary}}` | `80000` | Current annual gross salary for tax planning |
| `{{sabbatical_length_months}}` | `3` | Planned length of career break in months |
| `{{location_type}}` | `medium_col` | Cost of living: low_col, medium_col, high_col |
| `{{has_dependents}}` | `false` | Whether user has spouse/children |
| `{{current_health_coverage}}` | `employer` | Current insurance: employer, spouse, marketplace, none |

## Quick Start Prompt

Once installed, start with:

```
I'm burned out and considering a 3-month sabbatical. I make $85,000/year,
live in Austin (rent $1,600/month), and I'm single. Help me figure out
how much I need to save and what my health insurance options are.
```

## Core Capabilities

1. **Expense Calculator**: Track essential vs. discretionary spending
2. **Health Insurance Navigator**: Compare COBRA, ACA, spouse's plan, short-term
3. **Tax Optimization**: Roth conversions, capital gains harvesting
4. **Savings Target Calculator**: Minimum and recommended amounts
5. **Feasibility Assessment**: Red flags that suggest waiting
6. **Pre-Sabbatical Checklist**: 6-month, 3-month, 1-month timelines

## Key Formulas

**Minimum Sabbatical Fund:**
```
(Monthly Essential Expenses × Months) + Health Insurance + 1-Month Buffer
```

**Recommended Sabbatical Fund:**
```
(Monthly Essential Expenses × (Months + 1.5)) + Health Insurance + $1,500 Buffer
```

## Health Insurance Quick Reference

| Option | Monthly Cost | Best For |
|--------|-------------|----------|
| COBRA | $500-700 | Short gaps, keep same doctors |
| ACA Marketplace | $50-400 | Most sabbatical takers |
| Spouse's Plan | $200-500 | Married, spouse employed |
| Short-term | $100-300 | Healthy, emergencies only |

## Example Scenarios

### Urban Professional ($85k, Denver, Single)
- Monthly expenses (adjusted): $2,720
- Health insurance (ACA): $250/month
- **3-Month Minimum: $11,630**
- **Recommended: $15,000-17,000**

### HCOL with Mortgage ($140k, SF Bay Area)
- Monthly expenses (adjusted): $6,120
- Health insurance (ACA): $450/month
- **3-Month Minimum: $25,830**
- **Recommended: $32,000-38,000**

## Related Skills

- [Breaking Point Recovery Plan](/skills/productivity/breaking-point-recovery-plan/) - Burnout assessment and 90-day recovery roadmap
- [Budget Planner](/skills/productivity/budget-planner/) - Track monthly spending during sabbatical
- [Financial Goal Tracker](/skills/productivity/financial-goal-tracker/) - Track progress toward savings goal
- [Career Pivot Risk Calculator](/skills/productivity/career-pivot-risk-calculator/) - Evaluate career change risks
- [Employment Gap Storyteller](/skills/career/employment-gap-storyteller/) - Explain sabbatical in interviews

## Changelog

### v1.0.0 (2025-08-14)
- Initial release
- Complete expense calculator with 10 categories
- 6 health insurance options with cost comparisons
- Tax optimization strategies (Roth conversion, capital gains)
- 8-step pre-sabbatical checklist
- 3 detailed real-world scenarios

---
Downloaded from [Find Skill.ai](https://findskill.ai)
