---
name: non-compete-loophole-finder
version: 1.0.0
---

# Non-Compete Loophole Finder - Initialization

Analyze employment non-compete clauses to identify enforceability weaknesses, jurisdiction conflicts, overbreadth issues, and negotiation opportunities with plain-English explanations and actionable recommendations.

## Package Structure

```
non-compete-loophole-finder/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file - setup instructions
```

## Files to Generate

None required - this is a prompt-only skill.

## Quick Start

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude skills directory
cp -r non-compete-loophole-finder/ ~/.claude/skills/non-compete-loophole-finder/
```

### ChatGPT / Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into the AI assistant's system prompt or custom instructions
4. Start conversation with your non-compete clause

## Variables

Customize these values based on your situation:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{employee_jurisdiction}}` | `US-CA` | State/country where you live and work |
| `{{employer_jurisdiction}}` | `US-TX` | State/country where employer is incorporated |
| `{{employee_role_level}}` | `individual_contributor` | Your seniority: entry, individual_contributor, manager, director, executive |
| `{{restriction_duration_months}}` | `12` | How many months the non-compete lasts |
| `{{geographic_scope}}` | `statewide` | Geographic limitation: radius, statewide, nationwide, worldwide |
| `{{contract_signing_timing}}` | `at_hire` | When you signed: at_hire, during_employment, at_promotion, post_termination |

## Example Usage

**Prompt:**
```
I just got a job offer from a startup in Austin, Texas. My employment contract
has a non-compete that says I can't work for 'any company developing machine
learning software within the United States for 2 years after I leave.' I'm
from California and plan to be fully remote. Is this enforceable? What should
I negotiate?
```

**Expected Analysis Includes:**
- Plain English translation of the clause
- Jurisdiction conflict assessment (CA vs TX)
- Identified loopholes (overbreadth, vague terms)
- Risk assessment by scenario
- Negotiation recommendations
- Action items and next steps

## What This Skill Analyzes

### Loophole Categories
1. **Vagueness/Ambiguity** - Undefined terms like "competitive business"
2. **Overbreadth** - Scope broader than necessary to protect interests
3. **Consideration** - Missing or inadequate value exchange
4. **Circumstances** - Termination context affects enforceability
5. **Role-Based** - Restrictions disproportionate to employee's access
6. **Jurisdiction Conflicts** - Employee-friendly state laws may apply

### Enforceability Factors
- Geographic scope reasonableness
- Duration benchmarks by role level
- Legitimate business interest test
- State-specific enforcement standards
- FTC rule applicability (2024-2025)

## Jurisdiction Database

The skill includes analysis for:

**Employee-Friendly States:**
- California (non-competes unenforceable)
- North Dakota, Oklahoma, Minnesota
- Colorado, Washington (income thresholds)

**Employer-Friendly States:**
- Texas (blue pencil doctrine)
- Florida (statutory presumption of validity)
- Georgia, Massachusetts

**Balanced States:**
- New York, Illinois, Pennsylvania

## Important Disclaimers

This skill provides **educational analysis only** and does NOT constitute legal advice.

- Employment law varies significantly by jurisdiction
- Individual circumstances affect enforceability
- Always consult a qualified employment attorney before making career decisions
- The skill recommends legal consultation for complex situations

## Post-Init Steps

1. **Read your contract** - Locate all restrictive covenants (non-compete, non-solicitation, NDA)
2. **Note context** - When you signed, what you received, your role level
3. **Identify jurisdiction** - Where you work, where employer is based
4. **Prepare questions** - Specific scenarios you want analyzed

## Related Skills

- [Contract Analyzer](/skills/productivity/contract-analyzer/) - General contract analysis
- [Contract Reviewer](/skills/productivity/contract-reviewer/) - Red flag detection
- [Salary Negotiation Coach](/skills/productivity/salary-negotiation-coach/) - Negotiate offers
- [Job Offer Comparison Tool](/skills/productivity/job-offer-comparison-tool/) - Compare offers
- [Exit Interview Analyzer](/skills/productivity/exit-interview-analyzer/) - Navigate departures

## Version History

- **1.0.0** - Initial release with comprehensive jurisdiction analysis, loophole detection, and negotiation recommendations

---

Downloaded from [Find Skill.ai](https://findskill.ai)
