---
name: loan-agreement-analyzer
version: 1.0.0
---

# Loan Agreement Analyzer - Initialization

Review and assess personal or business loan agreements for fairness, identify unfavorable clauses, calculate true borrowing costs, and spot predatory lending red flags.

## What This Skill Does

This skill transforms your AI assistant into a specialized loan agreement analyst that can:

- **Extract key terms** from loan documents (rates, fees, covenants)
- **Calculate true costs** including APR, total interest, and monthly payments
- **Identify red flags** like prepayment penalties, cross-default clauses, and unfair terms
- **Analyze covenants** and explain their implications
- **Assess affordability** using debt-to-income ratios
- **Provide negotiation guidance** with specific language to use
- **Compare loan offers** to find the best value

## Structure

```
loan-agreement-analyzer/
├── SKILL.md    # Main skill prompt (copy this to your AI)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy the skill to your Claude Code skills directory
cp -r loan-agreement-analyzer/ ~/.claude/skills/loan-agreement-analyzer/
```

Then reference in your project's `CLAUDE.md`:

```markdown
## Available Skills

| Skill | Location | Use When |
|-------|----------|----------|
| loan-agreement-analyzer | ~/.claude/skills/loan-agreement-analyzer/ | Reviewing loan documents, calculating costs, identifying red flags |
```

### ChatGPT / Claude.ai / Gemini

1. Open `SKILL.md` in this package
2. Copy all content after the `---` frontmatter block
3. Paste into your AI assistant as a system prompt or custom instruction
4. Start analyzing loan agreements

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Paste the full `SKILL.md` content as instructions
3. Optionally enable file upload for PDF/document analysis
4. Save and share with your team

## Variables

Customize the skill behavior with these parameters:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{lender_type}}` | `bank` | Type of lender: bank, credit_union, p2p, fintech, private |
| `{{loan_category}}` | `personal` | Loan type: personal, mortgage, business, auto, student |
| `{{fairness_threshold}}` | `moderate` | Red flag sensitivity: lenient, moderate, strict |
| `{{borrower_dti_limit}}` | `0.43` | Maximum acceptable debt-to-income ratio |
| `{{comparison_benchmark}}` | `market_median` | Baseline: market_median, market_best |
| `{{risk_aversion}}` | `medium` | User's risk tolerance: low, medium, high |

## Example Usage

**Basic loan review:**
```
Review this personal loan agreement I received from my bank. I'm borrowing
$25,000 over 5 years with a stated 7.5% interest rate. Please extract all
the key terms, calculate the true APR including all fees, and highlight
any terms that seem unfair or unusual.
```

**Comparative analysis:**
```
I'm comparing three business loan offers for $50,000. Here are the terms:
- Lender A: 8.5%, 5 years, $500 origination fee
- Lender B: 9.0%, 6 years, no fees
- Lender C: 7.9%, 4 years, $750 origination fee

Which offer has the lowest total cost? Which has the best flexibility?
```

**Covenant compliance check:**
```
My business loan requires a 1.5x debt service coverage ratio. My current
EBITDA is $150,000 and annual debt service is $120,000. Am I in compliance?
What would happen if I'm not?
```

**Red flag deep dive:**
```
The loan document mentions a "negative pledge clause" in section 5.3.
Can you explain what this means in plain English and whether I should
be concerned about it?
```

## Key Features

### Cost Calculations
- True APR including all fees
- Monthly payment amounts
- Total interest over loan life
- Debt-to-income ratio analysis

### Red Flag Detection
- High severity: Confession of judgment, wage assignment, balloon payments
- Medium severity: Prepayment penalties, short grace periods, broad covenants
- Lower severity: Standard insurance requirements, reporting obligations

### Covenant Analysis
- Positive covenants (what you must do)
- Negative covenants (what you cannot do)
- Financial covenants (ratios to maintain)

### Fairness Scoring
- 1-10 scale based on APR, fees, covenants, and flexibility
- Benchmarked against industry standards
- Prioritized negotiation recommendations

## Industry Benchmarks

The skill includes current market benchmarks for:
- Personal loan APRs by credit score
- Mortgage rates and LTV requirements
- Business loan covenants and DSCR expectations
- Auto loan terms and depreciation considerations
- Student loan federal vs. private comparisons

## Limitations

- **Not legal advice** - educational analysis only
- **Not financial advice** - consult licensed advisors for major decisions
- **Market rates change** - benchmarks are approximate
- **Jurisdiction varies** - regulations differ by location
- **Document completeness** - analysis depends on what's provided

## Related Skills

- [Contract Analyzer](/skills/productivity/contract-analyzer/) - General contract review
- [Debt Elimination Sequencer](/skills/productivity/debt-elimination-sequencer/) - Debt payoff strategies
- [Mortgage Qualification Roadmap](/skills/productivity/mortgage-qualification-roadmap/) - Mortgage prep
- [Negotiation Stance Builder](/skills/productivity/negotiation-stance-builder/) - Negotiation tactics

---
Downloaded from [Find Skill.ai](https://findskill.ai)
