---
name: licensing-royalty-negotiator
version: 1.0.0
---

# Licensing & Royalty Negotiator - Initialization

Generate professional licensing terms, royalty structures, and negotiation strategies for IP deals including patents, software, trademarks, music, and character licensing with industry-standard benchmarks.

## Structure

```
licensing-royalty-negotiator/
├── SKILL.md    # Main skill prompt with instructions
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r licensing-royalty-negotiator/ ~/.claude/skills/licensing-royalty-negotiator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{ip_type}}` | `General IP` | Type of intellectual property (Software, Patent, Trademark, Music, Character, Brand) |
| `{{user_role}}` | `Licensor` | Whether you are selling rights (Licensor) or buying rights (Licensee) |
| `{{exclusivity}}` | `Non-exclusive` | Level of exclusivity (Exclusive, Non-exclusive, Sole) |
| `{{territory}}` | `Worldwide` | Geographic scope of the license |
| `{{royalty_basis}}` | `Net Sales` | Calculation basis for royalties (Net Sales, Wholesale, Retail, Usage) |
| `{{min_guarantee}}` | `10000` | Minimum annual guarantee amount in USD |

## Example Usage

**Basic licensing question:**
```
A gaming company wants exclusive license for my character in toys.
They're offering 6% royalty. What should I counter-propose?
```

**With variables set:**
```
ip_type=Character user_role=Licensor exclusivity=Exclusive territory=North America

Help me structure a counter-offer for my character licensing deal.
```

**Software licensing:**
```
I created a SaaS product and a larger company wants to white-label it.
They want perpetual rights for a one-time fee. How should I structure this?
```

## Industry Benchmarks (Quick Reference)

| Industry | Royalty Range | Notes |
|----------|---------------|-------|
| Software/SaaS | 8-15% | Per seat or usage |
| Consumer Products | 5-10% | Net wholesale |
| Characters/Brands | 10-20% | Guaranteed minimum required |
| Patents (Tech) | 1-5% | Often stacked |
| Music Sync | 10-25% | 50/50 pub/master split |
| Biotech/Pharma | 2-5% | Plus milestones |

## Key Protections Checklist

- [ ] Net Sales definition explicit (not Net Profit)
- [ ] Audit rights included (2x/year minimum)
- [ ] Minimum guarantees for exclusivity
- [ ] Quality control approval rights
- [ ] IP ownership retained (including improvements)
- [ ] Termination provisions for non-performance
- [ ] Indemnification from licensee

## Skill Capabilities

1. **Royalty Rate Benchmarking** - Industry-specific rate recommendations
2. **Term Sheet Generation** - Complete draft term sheets
3. **Negotiation Strategy** - Tactics, red flags, and alternatives
4. **Clause Drafting** - Protective legal language
5. **Counter-Proposal Creation** - Respond to offers professionally
6. **Deal Structure Options** - 3 structure alternatives per deal

---
Downloaded from [Find Skill.ai](https://findskill.ai)
