---
name: ip-protection-clause-writer
version: 1.0.0
---

# IP Protection Clause Writer - Initialization

An expert legal drafting assistant that creates enforceable intellectual property protection clauses for contracts. Draft work-for-hire provisions, IP ownership assignments, licensing agreements, derivative works clauses, and third-party disclosure requirements with proper legal language.

## Skill Overview

**What this skill does:**
- Generates work-for-hire clauses for software and creative work
- Creates IP ownership and assignment provisions
- Drafts licensing agreement clauses (exclusive/non-exclusive)
- Produces third-party and open-source component disclosure requirements
- Generates representations, warranties, and indemnification language
- Creates post-termination IP handling provisions
- Addresses derivative works ownership

**Target users:**
- Software developers and tech companies
- Creative professionals (designers, writers, artists)
- Startup founders drafting employment contracts
- Freelancers protecting their work
- Legal professionals seeking clause templates

## Package Structure

```
ip-protection-clause-writer/
├── SKILL.md    # Main skill prompt (copy to AI)
└── INIT.md     # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation Instructions

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r ip-protection-clause-writer/ ~/.claude/skills/ip-protection-clause-writer/

# Verify installation
ls ~/.claude/skills/ip-protection-clause-writer/
```

Then reference with: `Read ~/.claude/skills/ip-protection-clause-writer/SKILL.md`

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a system prompt or at the start of conversation
4. Begin with your IP clause request

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the skill content
3. Paste as initial context
4. Describe your contract scenario

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{ip_ownership_type}}` | `work_made_for_hire` | Ownership model: work_made_for_hire, assignment, joint_ownership, exclusive_license, non_exclusive_license |
| `{{scope_of_creation}}` | `scope_of_employment` | Boundary of IP ownership: scope_of_employment, commissioned_work_only, all_work_created |
| `{{pre_existing_ip_carveout}}` | `yes` | Whether to carve out pre-existing IP with a schedule (yes/no) |
| `{{derivative_works_control}}` | `licensor_controls` | Who controls derivative works: licensor_controls, licensee_owns, joint_ownership, prohibited |
| `{{license_exclusivity}}` | `non_exclusive` | License type: exclusive, non_exclusive, sole_license |
| `{{license_territory}}` | `worldwide` | Geographic scope: worldwide, us_only, specific_regions |

## Quick Start Examples

### Example 1: Software Development Contract
```
I'm hiring a freelance developer to build a custom CRM system. The developer
wants to retain ownership of their open-source database wrapper library.
Draft an IP clause that gives us ownership of the custom code while letting
them keep their library.
```

### Example 2: Open-Source Compliance
```
Our dev team proposed using npm packages in a new enterprise product.
We need a clause requiring third-party disclosure, prohibiting GPL/AGPL
licenses, allowing customer audits, and indemnifying us for prohibited code.
```

### Example 3: Creative Services
```
I'm a graphic designer creating a rebrand identity for a startup. The client
wants exclusive ownership, but I need portfolio rights. How do I structure
the IP rights and pricing?
```

### Example 4: Employment Agreement
```
Draft an IP clause for employment agreements that protects company IP while
respecting California Labor Code 2870 for employee side projects.
```

## Key Clause Types Included

1. **Work-for-Hire Clause** - Automatic ownership transfer for commissioned work
2. **Pre-Existing IP Carve-Out** - Protects creator's existing tools/libraries
3. **Licensing Agreement** - Scope, territory, term, sublicensing rights
4. **Derivative Works** - Four ownership options (licensor, licensee, joint, prohibited)
5. **Third-Party Disclosure** - Open-source compliance with prohibited license list
6. **Representations & Warranties** - Ownership, non-infringement, authority
7. **Indemnification** - Defense, damages, and costs allocation
8. **Post-Termination** - IP return, license survival, wind-down periods

## Legal Disclaimer

The clauses generated are templates for educational and starting-point purposes only. They do not constitute legal advice. Consult a licensed attorney in your jurisdiction before using any contract language in actual agreements. IP law varies significantly by jurisdiction.

## Jurisdiction Coverage

- **United States**: Work-for-hire statute (17 U.S.C. 101), California Labor Code 2870, Delaware Code 19 Section 805
- **European Union**: Stronger moral rights, GDPR implications
- **International**: Berne Convention, territorial patent rights

---
Downloaded from [Find Skill.ai](https://findskill.ai)
