---
name: gdpr-compliance-auditor
version: 1.0.0
---

# Initialization

GDPR Compliance Auditor systematically reviews organizational contracts, data processing agreements, and operational procedures to identify GDPR violations. It performs comprehensive compliance assessments, gap analysis, and risk identification across legal, technical, and organizational domains.

## Structure

```
gdpr-compliance-auditor/
├── SKILL.md      # Main skill prompt with full audit methodology
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r gdpr-compliance-auditor/ ~/.claude/skills/gdpr-compliance-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the YAML frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{audit_scope}}` | `comprehensive` | Scope: comprehensive, dpa_focused, dpia_only, dsar_process, security_focused |
| `{{severity_threshold}}` | `medium` | Minimum severity: critical, high, medium, low |
| `{{organization_size}}` | `medium` | Size: sme (<250), medium, large (1000+) |
| `{{supervisory_authority}}` | `GDPR_general` | Jurisdiction: ICO, CNIL, BfDI, DPA, GDPR_general |
| `{{remediation_timeline}}` | `90days` | Target: immediate, 30days, 90days, 6months |
| `{{data_subject_count}}` | `10000` | Estimated affected data subjects |

## Audit Types Supported

1. **DPA Compliance** - Verify Article 28(3) mandatory clauses in processor contracts
2. **Data Subject Rights** - Assess DSAR procedures and timeline compliance
3. **Security Assessment** - Evaluate Article 32 technical and organizational measures
4. **DPIA Assessment** - Review Data Protection Impact Assessments for high-risk processing
5. **ROPA Audit** - Verify Record of Processing Activities completeness

## Quick Start Examples

### Vendor Contract Review
```
Audit our AWS Data Processing Addendum for GDPR Article 28(3) compliance.
We process 100,000 EU customer records including names, emails, and purchase history.
Flag missing clauses, weak security obligations, and subprocessor authorization gaps.
```

### DSAR Process Assessment
```
Review our data subject access request procedure. We receive ~50 DSARs monthly
via email. Current average response time is 45 days. Identify compliance gaps
and recommend process improvements.
```

### Security Controls Audit
```
Assess our Article 32 security measures for our customer database:
- PostgreSQL with TLS in transit
- No encryption at rest
- Role-based access with quarterly reviews
- No documented incident response plan

Provide severity ratings and remediation priorities.
```

## Severity Levels

| Level | Description | Timeline |
|-------|-------------|----------|
| Critical | Active violation risking immediate enforcement | Immediate |
| High | Clear breach likely to result in fines | 30 days |
| Medium | Compliance gap requiring attention | 90 days |
| Low | Best practice improvement | 6 months |

## Fine Exposure Reference

| Tier | Maximum Fine | Covers |
|------|--------------|--------|
| Lower | €10M or 2% turnover | Organizational/technical (Arts. 8, 11, 25-39, 42-43) |
| Higher | €20M or 4% turnover | Principles/rights/transfers (Arts. 5-7, 9, 12-22, 44-49) |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
