---
name: employment-contract-auditor
version: 1.0.0
author: Find Skill.ai
license: MIT
---

# Employment Contract Auditor - Initialization

An AI skill for auditing employment contracts for legal compliance across jurisdictions. Identifies missing clauses, unenforceable terms, non-compete overreach, and statutory violations with risk scoring and remediation guidance.

## Target Users

- **HR Managers & Talent Acquisition** - Review contracts before signing
- **Legal Counsel & Compliance Officers** - First-pass compliance screening
- **SMBs without dedicated legal teams** - Affordable contract review
- **Multinational corporations** - Global workforce compliance
- **Employer of Record (EOR) services** - Multi-jurisdiction validation
- **Employees** - Understanding contract terms and fairness

## Core Capabilities

1. **Jurisdiction Detection** - Determine applicable employment law and resolve multi-jurisdiction conflicts
2. **Mandatory Clause Audit** - Check for jurisdiction-required elements (UK ERA s.1, EU Directive 2019/1152, etc.)
3. **Restrictive Covenant Analysis** - Evaluate non-compete, non-solicit, NDA enforceability by jurisdiction
4. **Statutory Minimum Compliance** - Verify wages, leave, termination notice meet legal floors
5. **Risk Scoring** - Prioritize issues by severity (Critical/High/Medium/Low)
6. **Consistency Check** - Detect internal contradictions within contract
7. **Fairness Audit** - Identify unreasonably one-sided terms

## Package Structure

```
employment-contract-auditor/
├── SKILL.md          # Main skill prompt (comprehensive legal analysis system)
└── INIT.md           # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill that works with any AI assistant.

## Post-Installation Steps

### For Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r employment-contract-auditor/ ~/.claude/skills/employment-contract-auditor/

# Verify installation
ls ~/.claude/skills/employment-contract-auditor/
```

### For ChatGPT / Gemini / Copilot

1. Open `SKILL.md` in a text editor
2. Copy all content after the YAML frontmatter (everything below the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Begin using with an employment contract

### For One-Time Use

Simply paste the SKILL.md content at the start of a new conversation with any AI assistant.

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `target_jurisdiction` | `US_Federal` | Primary jurisdiction (US, UK, DE, AU, CA, FR, state codes like CA, NY) |
| `contract_type` | `standard_employment` | Type: standard_employment, fixed_term, part_time, executive |
| `employee_seniority` | `mid_level` | Level: entry_level, mid_level, senior, executive, c_suite |
| `risk_tolerance` | `medium` | Risk appetite: low, medium, high |
| `secondary_jurisdictions` | `none` | Additional jurisdictions (comma-separated) |
| `include_fairness_audit` | `true` | Enable bias/fairness review |
| `salary_threshold` | `not_specified` | Annual salary for compensation-based analysis |

## Jurisdiction Coverage

**Detailed Rules Available:**
- United States (Federal + state-specific: CA, NY, MA, CO, IL, TX)
- United Kingdom (Employment Rights Act 1996, post-Brexit)
- European Union (Directive 2019/1152, country-specific: DE, FR, ES, NL)
- Australia (Fair Work Act 2009, Modern Awards, NES)
- Canada (Federal + provincial: Ontario, BC, Quebec)

**Supported Analysis:**
- Non-compete enforceability rules
- Probation period limits
- Fixed-term contract restrictions
- Mandatory clause requirements
- Statutory leave/termination minimums

## Example Usage

**Basic Contract Audit:**
```
I have an employment contract for a marketing manager in California earning $95,000/year. The contract includes a 12-month non-compete clause covering all of North America. Please audit for compliance and flag any unenforceable terms.
```

**Multi-Jurisdiction Analysis:**
```
We're hiring a remote software engineer in Berlin, Germany who will report to our Dublin office. The contract is governed by Irish law. What compliance gaps exist between German and Irish employment requirements?
```

**Executive Restrictive Covenant Review:**
```
Review these restrictive covenants for a UK VP of Sales (£150k salary): 24-month non-compete within 100 miles of any office, 3-year non-solicitation of any customer. Are these enforceable?
```

## Output Format

The skill generates structured compliance reports:

```
===============================================================
          EMPLOYMENT CONTRACT COMPLIANCE AUDIT
===============================================================

EXECUTIVE SUMMARY
-----------------
Overall Compliance Score: XX%
Risk Level: [Low/Moderate/High/Critical]

CRITICAL FINDINGS (Immediate Action Required)
---------------------------------------------
[Issues requiring immediate attention]

HIGH/MEDIUM/LOW PRIORITY FINDINGS
---------------------------------
[Tiered issue list]

DETAILED ANALYSIS
-----------------
[Jurisdiction, clauses, covenants, statutory compliance]

REMEDIATION ROADMAP
-------------------
[Prioritized action items]

DISCLAIMER
----------
[Legal advice disclaimer]
===============================================================
```

## Legal Disclaimer

This skill provides legal analysis for **informational purposes only**. It does NOT constitute legal advice. Users should consult qualified employment lawyers for:

- Binding legal opinions
- High-stakes employment decisions
- Complex multi-jurisdictional matters
- Litigation or dispute resolution
- Contract negotiation strategy

Employment law changes frequently. Always verify current statutory requirements with local counsel.

## Related Skills

- [Contractor vs. Employee Classifier](/skills/legal/contractor-vs-employee-classifier/) - Worker classification tests
- [Wage & Hour Compliance Checker](/skills/legal/wage-hour-compliance-checker/) - FLSA violation audits
- [Non-Compete Loophole Finder](/skills/legal/non-compete-loophole-finder/) - Restrictive covenant analysis
- [Freelance Contract Generator](/skills/legal/freelance-contract-generator/) - Contractor agreements

## Research Sources

- AI-assisted German Employment Contract Review Dataset (arxiv.org)
- CUAD: Contract Understanding Atticus Dataset (atticusprojectai.org)
- ContractNLI: Stanford NLP (stanfordnlp.github.io)
- Employment Contract Essentials - Teamed Global
- International Employment Law Guide - Deloitte
- Labor Regulations Throughout the World - World Bank

---
Downloaded from [Find Skill.ai](https://findskill.ai)
