---
name: contractor-vs-employee-classifier
version: 1.0.0
---

# Contractor vs. Employee Classifier - Initialization

Determine worker classification (1099 vs W-2) using IRS 3-factor, DOL 6-factor, and state ABC tests with penalty risk assessment and compliance documentation guidance.

## Package Contents

```
contractor-vs-employee-classifier/
├── SKILL.md    # Main skill prompt with classification frameworks
└── INIT.md     # This initialization file
```

## What This Skill Does

This skill helps you determine whether a worker should be classified as an independent contractor (1099) or an employee (W-2) under US federal tax law and labor regulations. It applies:

- **IRS 3-Factor Test** - Behavioral control, financial control, relationship type
- **DOL 6-Factor Economic Reality Test** - 2024 Department of Labor framework
- **State ABC Test** - Stricter state-level tests (CA, MA, NJ, etc.)

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r contractor-vs-employee-classifier/ ~/.claude/skills/contractor-vs-employee-classifier/
```

Then reference in prompts or add to your project's CLAUDE.md:

```markdown
## Available Skills
- `contractor-vs-employee-classifier` - Worker classification analysis
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or conversation

### Custom GPT / Claude Project

Add the SKILL.md content to your system prompt or knowledge base.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{worker_tenure_months}}` | `12` | Duration of work engagement in months |
| `{{control_intensity}}` | `moderate` | Level of supervision (low, moderate, high) |
| `{{profit_loss_exposure}}` | `false` | Whether worker can affect earnings through skill |
| `{{work_location}}` | `us_federal` | Jurisdiction (us_federal, ca_abc, ny_common_law) |
| `{{tool_provision}}` | `company` | Who provides equipment (company, contractor, mixed) |
| `{{schedule_flexibility}}` | `set_hours` | Schedule type (set_hours, flexible, self_directed) |
| `{{benefits_offered}}` | `false` | Whether company offers health/retirement/PTO |
| `{{payment_method}}` | `hourly_wage` | Compensation (hourly_wage, salary, per_project, invoice) |

## Example Usage

### Quick Classification Check

```
Classify this worker: Sarah works 9-5 Monday-Friday at our office. We provide
her laptop and software. She attends team meetings and follows our documented
procedures for content creation. She earns $5,000/month salary with no
profit/loss opportunity. Should she be 1099 or W-2?
```

### State Compliance Analysis

```
Our platform connects independent contractors for delivery services. Federally,
we believe they qualify as contractors under the economic reality test due to
flexibility and low control. However, we operate in California. How does
California's ABC test change the analysis?
```

### Misclassification Risk Assessment

```
We have 12 contractors earning $3,500/month average over the past 18 months.
An audit suggests they should have been classified as W-2 employees. We weren't
intentionally hiding this—we just misunderstood the rules. What are our penalties
and remediation options?
```

## Key Concepts

- **Behavioral Control** - Who controls how, when, where work is performed
- **Financial Control** - Equipment provision, expense reimbursement, profit/loss opportunity
- **Type of Relationship** - Permanence, benefits, exclusivity, integration
- **ABC Test** - Stricter 3-part test used in CA, MA, NJ (presumption of employment)
- **Economic Reality Test** - DOL's 6-factor totality analysis (2024 rule)
- **Form SS-8** - IRS form to request official classification determination

## Related Skills

- [Non-Compete Loophole Finder](/skills/legal/non-compete-loophole-finder/) - Employment contract analysis
- [Offer Letter Generator](/skills/industry/offer-letter-generator/) - W-2 employment documentation
- [Subcontractor Agreement Builder](/skills/industry/subcontractor-agreement-builder/) - 1099 contractor agreements
- [HR Analytics](/skills/data-analytics/hr-analytics/) - Workforce data analysis
- [Financial Risk Assessment](/skills/industry/financial-risk-assessment/) - Compliance risk exposure

## Disclaimer

This skill provides educational guidance based on established classification tests. It does NOT constitute legal or tax advice. High-stakes classification decisions should be reviewed by qualified legal counsel or tax professionals.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
