---
name: termination-letter-generator
version: 1.0.0
---

# Initialization

AI-powered tool for drafting professional, legally compliant termination letters for employees, contractors, and vendors. Handles multiple termination types (for-cause, layoffs, vendor breaches), jurisdiction-specific requirements, and appropriate tone adjustments.

## Structure

- `SKILL.md` - Main skill prompt with templates, jurisdiction rules, and best practices

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r termination-letter-generator/ ~/.claude/skills/termination-letter-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `termination_type` | `without_cause` | Type of termination: for_cause, without_cause, layoff, restructuring, vendor_breach, mutual_agreement |
| `recipient_type` | `employee` | Who is being terminated: employee, contractor, vendor, consultant, independent_contractor |
| `notice_period_days` | `14` | Days between notice and effective termination (0-180) |
| `include_severance` | `false` | Whether to include severance package details |
| `jurisdiction` | `general_us` | Legal jurisdiction: california, new_york, texas, general_us, canada, uk, australia |
| `tone` | `professional` | Communication style: compassionate, professional, firm, neutral |

## Quick Start Examples

### For-Cause Employee Termination
```
Generate a termination letter for John Smith, Software Engineer at TechCorp.
Reason: Performance issues despite 3 written warnings over 6 months.
Effective date: [Date]
Jurisdiction: California
Tone: Professional and firm
Include: NDA reminder, final paycheck details, property return
```

### Layoff with Severance
```
Create a compassionate termination letter for Sarah Chen, Marketing Manager.
Reason: Department restructuring (not performance-related)
Severance: 4 weeks pay
Include: COBRA info, outplacement services, positive reference eligibility
Jurisdiction: New York
```

### Vendor Contract Termination
```
Draft a vendor termination letter to ABC Logistics Inc.
Contract: Service Agreement dated March 2022, #VND-2022-0847
Reason: Material breach - failed to meet 95% SLA for 4 consecutive quarters
Notice period: 30 days per contract section 7.2
Include: Final invoice reconciliation, data return requirements, surviving NDA
```

## Key Features

- **5 Letter Types**: For-cause, without-cause, vendor breach, convenience, resignation acceptance
- **Jurisdiction Support**: CA, NY, TX, IL, General US, Canada, UK, Australia
- **Legal Compliance**: State-mandated notices, final pay rules, WARN Act requirements
- **Tone Adjustment**: Compassionate for layoffs, firm for misconduct, neutral for vendors
- **Supporting Docs**: Recommends separation agreements, COBRA forms, property checklists

## Legal Disclaimer

Generated letters are templates requiring review. For for-cause terminations, senior employees, or complex situations, always have employment counsel review before sending. This tool does not constitute legal advice.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
