---
name: succession-planning-framework
version: 1.0.0
---

# Succession Planning Framework - Initialization

Strategic talent management system for identifying, assessing, and developing internal candidates for critical leadership positions using 9-box grids, competency frameworks, and individual development plans.

## Structure

```
succession-planning-framework/
├── SKILL.md      # Main skill prompt (comprehensive)
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
# Copy to Claude Code skills directory
cp -r succession-planning-framework/ ~/.claude/skills/succession-planning-framework/

# Verify installation
ls ~/.claude/skills/succession-planning-framework/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy the entire content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as system instructions or initial prompt
4. Start with: "I need help with succession planning for my organization"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{critical_roles}}` | `Executive + key operational (3-5 positions)` | Which positions require succession planning focus |
| `{{assessment_frequency}}` | `Quarterly with annual comprehensive review` | How often talent is assessed and succession status updated |
| `{{bench_strength_target}}` | `3+ successors per critical role` | Desired number of identified candidates for each critical position |
| `{{development_timeline}}` | `1-3 years` | Expected duration to develop high-potential employees into readiness |
| `{{diversity_goal}}` | `40%+ underrepresented groups in successor pools` | Target percentage for diverse candidates in succession pipelines |
| `{{emergency_review_frequency}}` | `Semi-annually` | How often contingency plans are updated |

## Usage Scenarios

### Scenario 1: Annual Talent Review
```
Help me design our annual talent review process. We have 150 employees
across 5 departments and need to identify high-potentials for 8 critical roles.
```

### Scenario 2: CFO Succession
```
Our CFO is retiring in 18 months. Help me create an Individual Development
Plan for our Controller who we've identified as the top successor candidate.
```

### Scenario 3: Emergency Planning
```
Our board wants an emergency succession plan for the CEO and CFO roles.
Create contingency protocols with communication templates.
```

### Scenario 4: Diversity Initiative
```
Our leadership team lacks diversity. Help me build a program to expand
representation in our succession pipeline.
```

### Scenario 5: 9-Box Assessment
```
Train me on using the 9-box grid. I need to assess my team of 12 managers
for succession to director-level roles.
```

## Key Workflows Included

1. **Annual Talent Review**: Governance setup, assessment distribution, 9-box mapping, calibration sessions, gap identification
2. **Individual Development Plans**: Discovery conversations, competency gap analysis, 70-20-10 activities, progress tracking
3. **Emergency Succession**: Critical role identification, interim successor designation, transition protocols, communication templates
4. **Diversity Pipeline Building**: Baseline analysis, bias auditing, targeted development programs, accountability metrics
5. **Competency Framework Development**: Input gathering, framework drafting, validation, implementation

## Output Formats Available

- Assessment templates (Word/PDF compatible)
- 9-box grid templates
- Individual Development Plans
- Competency frameworks
- Emergency succession checklists
- Communication templates
- Dashboard report structures
- Training materials for managers

## Related Skills

- Employee Development Plan Generator
- Performance Review Generator
- Culture Fit Evaluator
- Candidate Screener
- Exit Interview Analyzer

---
Downloaded from [Find Skill.ai](https://findskill.ai)
