---
name: skills-matrix-generator
version: 1.0.0
---

# Skills Matrix Generator - Initialization

Map team competencies against role requirements, visualize skill gaps, and generate actionable hiring vs. training recommendations with succession planning insights.

## Structure

```
skills-matrix-generator/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r skills-matrix-generator/ ~/.claude/skills/skills-matrix-generator/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or first message
4. Begin your conversation with your team and skill requirements

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{proficiency_scale}}` | `Beginner/Intermediate/Advanced/Expert` | Rating system for skill assessment |
| `{{assessment_method}}` | `self_assessment + manager_rating` | Data sources for skill evaluation |
| `{{gap_threshold}}` | `70` | Percentage below which gaps are flagged critical |
| `{{scope}}` | `team` | Unit of analysis: team, department, or organization |
| `{{include_succession}}` | `true` | Whether to include succession planning analysis |
| `{{skill_weighting}}` | `role-specific` | How to weight skill importance |

## Quick Start

After installation, start with:

```
"Map our [team size]-person [department] team against [project/initiative] requirements: [list skills]. Rate each team member using [proficiency scale]. Generate a skills matrix, identify critical gaps, and recommend whether to hire or train for each gap."
```

## Example Usage

**Engineering Team Assessment:**
```
"Map our 12-person product engineering team against Q1 platform migration: Kubernetes, Docker, Go, PostgreSQL, API design, CI/CD. Rate using Beginner/Intermediate/Advanced/Expert. Identify top 3 critical gaps and recommend hire vs. train for each."
```

**Succession Planning:**
```
"Map our 50-person engineering org for Tech Lead succession. Requirements: system design, mentoring, communication, strategic thinking. Identify top 3 candidates and create development plans."
```

**Project Readiness:**
```
"Assess our 8-person data team readiness for the ML pipeline project. Required skills: Python, SQL, MLOps, data modeling, Airflow. Generate readiness score and staffing recommendations."
```

## Core Capabilities

1. **Skill Assessment & Mapping** - Create structured assessments with proficiency levels
2. **Gap Analysis & Reporting** - Identify and prioritize skill gaps by business impact
3. **Training Path Generation** - Recommend targeted development programs
4. **Hiring vs. Development Engine** - Cost-benefit analysis for gap closure decisions
5. **Succession Planning** - Map backup candidates for critical roles
6. **Dashboard & Visualization** - Stakeholder-appropriate reporting formats

## Related Skills

- Skill Gap Analyzer - Individual career gap analysis
- Employee Development Plan Generator - Training plans from gaps
- Performance Review Templates - Assessment documentation
- Hiring Decision Validator - Hiring ROI analysis
- Learning Path Designer - Training curriculum design

---

Downloaded from [Find Skill.ai](https://findskill.ai)
