---
name: risk-register-generator
version: 1.0.0
---

# Risk Register Generator - Initialization

An AI skill for creating comprehensive risk registers with probability-impact analysis, mitigation strategies, and governance reporting aligned with ISO 31000, COSO ERM, PMBOK, and PRINCE2 frameworks.

## What This Skill Does

- Systematically identifies strategic, operational, financial, and technical risks
- Scores risks using probability × impact calculations with configurable scales
- Generates mitigation strategies (Avoid, Mitigate, Transfer, Accept, Escalate)
- Creates executive dashboards and heat maps for governance reporting
- Aligns with major risk management frameworks (ISO 31000, COSO ERM, PMBOK, PRINCE2)
- Provides industry-specific risk considerations for technology, construction, finance, healthcare, and manufacturing

## Structure

```
risk-register-generator/
├── SKILL.md      # Main skill prompt (copy to your AI assistant)
├── INIT.md       # This initialization file
└── index.md      # Website listing metadata
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md file contains all instructions.

## Post-Init Steps

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r risk-register-generator/ ~/.claude/skills/risk-register-generator/
```

Then reference in your Claude Code session:
```
Use the risk-register-generator skill to create a risk register for my project
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Begin your conversation with project context

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Paste SKILL.md content as the system instructions
3. Configure knowledge sources if desired
4. Share with your team for consistent risk management

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `project_context` | Software implementation project | The project or organizational context for risk identification |
| `risk_categories` | Strategic, Operational, Financial, Technical, Schedule, Resource, External | Categories to classify and organize risks |
| `probability_scale` | 1-5 (1=Very Low, 5=Very High) | Scale for likelihood assessment |
| `impact_scale` | 1-5 (1=Negligible, 5=Catastrophic) | Scale for severity measurement |
| `risk_threshold` | 12 | Score above which risks require escalation |
| `framework_standard` | ISO 31000 | Compliance framework alignment |

## Example Usage

**Basic Project Risk Register:**
```
Create a risk register for our 6-month mobile app development project.
Budget: $200K. Team: 5 developers, 1 PM, 2 QA.
Key dependencies: Third-party payment API, cloud infrastructure.
```

**Enterprise Implementation:**
```
Generate a comprehensive risk register for an 18-month ERP implementation
across Finance, HR, and Operations. Budget: $2.5M.
Constraints: Legacy system cutover, Q4 freeze period, multi-site coordination.
Risk appetite: Moderate - accept up to 10% budget variance, zero data loss tolerance.
Framework: COSO ERM alignment required for board reporting.
```

**Supply Chain Restructuring:**
```
Develop a risk register for consolidating from 12 to 5 suppliers
with production relocation from Asia to Mexico. Timeline: 18 months.
Current spend: $50M annually. Critical products: 8 SKUs (80% revenue).
Conservative risk appetite - cannot tolerate service disruption > 5%.
```

## Framework Quick Reference

| Framework | Key Focus | Best For |
|-----------|-----------|----------|
| **ISO 31000** | Integrated, structured, customized approach | General organizations |
| **COSO ERM** | 5 components, strategic alignment | Enterprise-wide programs |
| **PMBOK** | 7 processes, EMV, contingency planning | Project-based initiatives |
| **PRINCE2** | Business/Project/Stage categories | Structured project environments |

## Risk Score Priority Zones

| Score Range | Priority | Action Required |
|-------------|----------|-----------------|
| 20-25 | Critical | Immediate attention, executive escalation |
| 12-19 | High | Active mitigation, regular monitoring |
| 6-11 | Medium | Planned response, periodic review |
| 1-5 | Low | Accept and monitor, minimal intervention |

## Output Formats Available

1. **Executive Dashboard** - High-level risk profile summary
2. **Heat Map** - Visual probability-impact matrix
3. **Risk Register Table** - Detailed tabular format
4. **Risk Response Plans** - Individual mitigation documents

## Related Skills

- **Vendor Risk Assessment** - Third-party and supplier risk evaluation
- **Financial Risk Assessment** - Monetary exposure analysis
- **Business Continuity Plan Generator** - Disaster recovery planning
- **Audit Trail Documentation** - Compliance documentation

---
Downloaded from [Find Skill.ai](https://findskill.ai)
