---
name: revenue-recognition-analyzer
version: 1.0.0
---

# Revenue Recognition Analyzer - Initialization

A comprehensive AI skill for analyzing customer contracts under ASC 606 (US GAAP) and IFRS 15 (International) revenue recognition standards. Guides users through the five-step framework for identifying performance obligations, estimating transaction prices, allocating revenue, and creating audit-ready documentation.

## Package Structure

```
revenue-recognition-analyzer/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
├── INIT.md           # This initialization file
└── index.md          # Hugo page (for website only)
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md file contains all necessary instructions for the AI assistant.

## Post-Initialization Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r revenue-recognition-analyzer/ ~/.claude/skills/revenue-recognition-analyzer/
```

Then reference in your CLAUDE.md or invoke directly.

### For ChatGPT, Gemini, Copilot Users

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Begin your revenue recognition analysis

### For Custom GPT / Claude Project Setup

1. Create a new Custom GPT or Claude Project
2. Paste the SKILL.md content into the instructions/system prompt
3. Configure the following variables as needed:
   - `accounting_standard`: ASC 606, IFRS 15, or Both
   - `variable_consideration_method`: expected_value or most_likely_amount
   - `progress_measurement_method`: input_method or output_method

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{accounting_standard}}` | `ASC 606` | Which standard applies: ASC 606 (US GAAP), IFRS 15 (International), or Both |
| `{{variable_consideration_method}}` | `expected_value` | How to estimate variable amounts: expected_value (probability-weighted) or most_likely_amount (binary outcomes) |
| `{{progress_measurement_method}}` | `input_method` | How to measure over-time progress: input_method (costs) or output_method (milestones) |
| `{{collectibility_threshold}}` | `0.75` | Probability threshold for Step 1 collectibility: 0.75 for ASC 606, 0.50 for IFRS 15 |
| `{{ssp_estimation_priority}}` | `observable` | SSP estimation hierarchy priority: observable, comparable, cost_plus_margin, or residual |
| `{{contract_modification_threshold}}` | `0.10` | Materiality threshold (10%) for contract modifications requiring reassessment |

## Core Capabilities

1. **Contract Analysis & Classification** - Assess whether contracts meet ASC 606/IFRS 15 scope criteria
2. **Performance Obligation Identification** - Apply the two-part distinct test to identify separate promises
3. **Standalone Selling Price (SSP) Estimation** - Determine SSP using hierarchy of estimation methods
4. **Variable Consideration Modeling** - Estimate and constrain variable amounts (bonuses, penalties, usage-based)
5. **Revenue Recognition Timing** - Determine over-time vs. point-in-time recognition
6. **Contract Modification Analysis** - Assess modifications as separate contracts or catch-up adjustments
7. **Disclosure Documentation** - Prepare audit-ready workpapers and financial statement disclosures

## Example Usage

```
Analyze this 12-month SaaS subscription contract for ASC 606 compliance:
- Annual license fee: $120,000 (paid upfront)
- Implementation services: $15,000 (1-month completion)
- Technical support: Included in license
- Customer can use software immediately upon go-live
- Standalone selling price of similar implementations: $18,000-$22,000

Identify performance obligations, determine transaction price allocation
using relative SSP, and create a monthly revenue recognition schedule.
```

## Related Skills

- Accounting Close Checklist Generator - Month-end/year-end close procedures
- Audit Trail Documentation - SOX/GAAP/IFRS compliance documentation
- Financial Risk Assessment - Credit risk and collectibility analysis
- Financial Analytics - Revenue analysis and financial modeling
- Inventory Valuation Method Optimizer - LIFO/FIFO/Weighted Average selection

## Technical Standards Covered

- **ASC 606** - Revenue from Contracts with Customers (US GAAP)
- **IFRS 15** - Revenue from Contracts with Customers (International)
- **ASC 606-10-50** - Disclosure requirements
- **IFRS 15.110-129** - Disclosure requirements

## Audit Workpaper Outputs

The skill generates documentation suitable for:
- External audit support
- SOX control testing
- Internal audit review
- Management reporting
- Financial statement preparation

---
Downloaded from [Find Skill.ai](https://findskill.ai)
