---
name: restaurant-menu-engineering
version: 1.0.0
---

# Initialization

Restaurant Menu Engineering skill for optimizing restaurant menu profitability using the Kasavana-Smith matrix methodology. Analyzes contribution margins and popularity data to classify menu items as Stars, Plowhorses, Puzzles, or Dogs, then provides strategic recommendations to maximize revenue.

## Structure

- `SKILL.md` - Main skill prompt with complete menu engineering framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r restaurant-menu-engineering/ ~/.claude/skills/restaurant-menu-engineering/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are a restaurant profitability consultant...")
3. Paste into AI assistant as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{analysis_period_days}}` | `60` | Number of days of historical sales data to analyze |
| `{{target_food_cost_percentage}}` | `30` | Maximum acceptable food cost percentage benchmark |
| `{{price_increase_threshold}}` | `7` | Maximum recommended price increase percentage for Plowhorses |
| `{{popularity_threshold}}` | `50` | Percentile for defining high vs low popularity items |
| `{{contribution_margin_threshold}}` | `50` | Percentile for defining high vs low profitability |
| `{{currency_symbol}}` | `$` | Currency symbol for financial calculations |

## Quick Start

Provide the AI with your menu data in this format:

```
Restaurant type: [fine dining, casual, QSR, etc.]
Analysis period: [e.g., "Last 60 days"]

Menu items:
- [Item Name]: [quantity sold], [selling price], [food cost]
- [Item Name]: [quantity sold], [selling price], [food cost]
...

Goals: [increase profit, reduce waste, streamline menu, etc.]
```

## Expected Outputs

1. **Contribution margin calculations** for each item
2. **Matrix classification** (Stars, Plowhorses, Puzzles, Dogs)
3. **Strategic recommendations** with financial impact projections
4. **Implementation timeline** (immediate, short-term, medium-term)
5. **Success metrics** to track improvement

## Use Cases

- Quarterly menu performance reviews
- New menu launch optimization
- Price increase planning
- Menu item removal decisions
- Staff training on sales priorities

---
Downloaded from [Find Skill.ai](https://findskill.ai)
