---
name: regulatory-compliance-readiness-auditor
version: 1.0.0
---

# Initialization

Regulatory Compliance Readiness Auditor - Systematically evaluate organizational preparedness for AI regulations, GDPR, EU AI Act, and data privacy frameworks with gap analysis, risk scoring, and remediation planning.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive compliance audit methodology

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r regulatory-compliance-readiness-auditor/ ~/.claude/skills/regulatory-compliance-readiness-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{assessment_framework}}` | `COSO` | Compliance framework (COSO, ISO19011, NIST_AI_RMF, SOC2, GDPR_specific) |
| `{{regulatory_scope}}` | `GDPR,CCPA` | Comma-separated list of applicable regulations |
| `{{risk_threshold}}` | `high` | Minimum risk level for immediate remediation (critical, high, medium, low) |
| `{{assessment_depth}}` | `comprehensive` | Assessment scope (lightweight, standard, comprehensive, forensic) |
| `{{fairness_metrics}}` | `demographic_parity,equal_opportunity,disparate_impact` | AI fairness metrics to evaluate |
| `{{maturity_scale}}` | `5` | Number of maturity levels for scoring (3-5) |
| `{{evidence_retention_days}}` | `2555` | Days to retain compliance evidence (7 years default) |

## Core Capabilities

1. **Compliance Gap Assessment** - Systematic evaluations against GDPR, EU AI Act, CCPA, HIPAA, SOX
2. **Regulatory Landscape Mapping** - Identify applicable regulations by industry and geography
3. **Risk Prioritization & Scoring** - Weighted risk matrices for resource allocation
4. **AI Fairness & Bias Auditing** - Demographic parity, equal opportunity, disparate impact analysis
5. **Technical Documentation Review** - DPIA, audit trails, system architecture verification
6. **Control Effectiveness Testing** - COSO/ISO-based control validation

## Key Workflows

### Workflow 1: Regulatory Landscape Mapping
- Document organizational profile
- Identify applicable regulations
- Classify AI systems by risk level
- Create regulatory requirement matrix
- Assign domains to responsible teams

### Workflow 2: Compliance Gap Assessment
- Select assessment framework
- Develop assessment checklist
- Gather evidence (documents, interviews, observations)
- Map controls to requirements
- Calculate readiness scores (1-5 maturity scale)

### Workflow 3: AI Fairness Audit
- Identify systems requiring fairness audits
- Define protected attributes
- Segment test data by demographics
- Calculate fairness metrics
- Conduct adversarial testing
- Document findings and remediation

### Workflow 4: Documentation Review
- Develop documentation checklist
- Conduct inventory
- Assess against completeness/accuracy/currency criteria
- Create consolidated evidence package
- Establish maintenance schedule

### Workflow 5: Remediation Planning
- Consolidate all gaps
- Evaluate remediation options
- Assign priority scores (weighted matrix)
- Create phased implementation roadmap
- Establish success metrics and checkpoints

## Quick Start

1. Install skill using post-init steps above
2. Start conversation: "I need to assess our compliance readiness for [regulation]"
3. Provide organizational context when prompted
4. Receive structured gap analysis and remediation roadmap

## Supported Regulations

- GDPR (General Data Protection Regulation)
- EU AI Act (High-risk AI systems)
- CCPA/CPRA (California privacy)
- HIPAA (Healthcare)
- SOX (Sarbanes-Oxley)
- PCI DSS (Payment cards)
- NIST AI RMF (AI risk management)
- ISO 27001 (Information security)

## Assessment Frameworks

- COSO Integrated Framework (5 components, 17 principles)
- ISO 19011 (7 audit principles)
- NIST AI RMF (Govern, Map, Measure, Manage)
- SOC 2 Trust Services Criteria
- AICPA Privacy Maturity Model

---
Downloaded from [Find Skill.ai](https://findskill.ai)
