---
name: process-improvement-auditor
version: 1.0.0
---

# Initialization

**Process Improvement Auditor** - Audit business processes to identify bottlenecks, waste, and inefficiencies using DMAIC, Lean Six Sigma, and Value Stream Mapping methodologies for measurable operational improvements.

## Structure

```
process-improvement-auditor/
├── SKILL.md     # Main skill prompt (685+ lines)
└── INIT.md      # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r process-improvement-auditor/ ~/.claude/skills/process-improvement-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{process_name}}` | `Order-to-Cash` | Name of the business process being audited |
| `{{audit_scope}}` | `end-to-end` | Scope: end-to-end, specific function, or cross-department |
| `{{primary_metric}}` | `cycle_time` | Key metric: cycle_time, cost, quality, compliance, throughput |
| `{{organization_size}}` | `medium` | Context: startup, small, medium, enterprise |
| `{{data_availability}}` | `partial` | Data access: full, partial, limited |
| `{{implementation_timeline}}` | `8_weeks` | Window: immediate, 4_weeks, 8_weeks, 6_months |
| `{{risk_tolerance}}` | `moderate` | Change appetite: conservative, moderate, aggressive |

## Skill Capabilities

1. **Process Discovery and Mapping** - Translate verbal descriptions into documented flows, SIPOC diagrams, and handoff documentation
2. **Bottleneck Identification** - Pinpoint constraints using Theory of Constraints, capacity analysis, and queue measurement
3. **Root Cause Analysis** - Apply 5 Whys, Fishbone diagrams, and data-driven hypothesis validation
4. **Performance Metrics** - Establish baseline KPIs, leading/lagging indicators, and dashboards
5. **Waste Characterization** - Identify and classify the 8 Wastes of Lean (DOWNTIME)
6. **Improvement Prioritization** - Create impact/effort matrices, quick wins, and ROI estimates
7. **Sustainability Planning** - Design control mechanisms, standard work, and monitoring systems

## Key Methodologies Included

- **DMAIC** (Define, Measure, Analyze, Improve, Control)
- **Value Stream Mapping** (Current-state and future-state)
- **Lean Six Sigma** principles and tools
- **Theory of Constraints** bottleneck analysis
- **Kaizen** continuous improvement
- **PDCA/PDSA** improvement cycles

## Structured Workflows

1. **Rapid Process Audit (2-3 days)** - Quick diagnostic assessment with stakeholder interviews, Gemba walks, and executive summary
2. **Data-Driven Bottleneck Analysis (1-2 weeks)** - Transaction log analysis, process mining, statistical root cause analysis
3. **Cross-Functional Improvement Workshop (3-4 weeks)** - Strategic improvement initiative with Value Stream Mapping and implementation planning

## Industry-Specific Patterns

- Healthcare (scheduling, handoffs, documentation)
- Manufacturing (OEE, setup time, quality)
- Financial Services (approval loops, automation opportunities)
- Supply Chain (visibility, variation, integration)
- Professional Services (utilization, scope, estimation)

## Example Usage

```
Audit our customer onboarding process. We're seeing 15-day average cycle time
but competitors achieve 3-5 days. Team of 12 people: 2 data entry specialists,
5 account managers, 3 compliance reviewers, 2 IT/systems support. Process spans
intake form, credit check, system setup, compliance review, and account activation.
Identify the top 3 bottlenecks with impact estimates, suggest quick wins for 2-week
implementation, and list metrics we should collect for deeper analysis.
```

## Expected Outputs

- Current-state process maps (swim-lane format)
- Bottleneck priority lists with impact estimates
- Root cause analysis (5 Whys, Fishbone diagrams)
- Quick win recommendations with implementation steps
- Improvement roadmaps with milestones
- Control plans for sustainability
- KPI dashboards and monitoring mechanisms

---
Downloaded from [Find Skill.ai](https://findskill.ai)
