---
name: offer-letter-generator
version: 1.0.0
---

# Initialization

Generate professional, legally compliant employment offer letters with equity calculations, vesting schedules, compliance validation, and e-signature integration for HR teams.

## Structure

- `SKILL.md` - Main skill prompt with offer letter generation workflows

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r offer-letter-generator/ ~/.claude/skills/offer-letter-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `candidate_name` | `[Candidate Name]` | Full legal name of the candidate receiving the offer |
| `base_salary_annual` | `150000` | Annual gross salary in USD for compensation calculations |
| `vesting_schedule_type` | `4-year_1-year-cliff` | Equity vesting preference (4-year_1-year-cliff, 3-year_6-month-cliff, 4-year_no-cliff, custom) |
| `equity_grant_shares` | `0` | Total number of shares in option/RSU grant (0 for salary-only roles) |
| `work_location_type` | `on-site` | Work arrangement (on-site, remote, hybrid, hybrid-flexible, location-independent) |
| `contingency_requirements` | `standard` | Pre-employment conditions (standard, extended, minimal, board-approval-only) |

## Core Capabilities

1. **Standard Full-Time Offers** - Salary, benefits, contingencies, at-will language
2. **Executive Offers** - Severance, bonuses, clawbacks, board approval
3. **Equity Offers** - RSUs/ISOs/NSOs, vesting schedules, 83(b) reminders
4. **Remote/Hybrid Offers** - Equipment stipends, timezone, tax implications
5. **Internal Promotions** - Side-by-side comparisons, equity continuation
6. **Contract Offers** - Fixed-term, IP ownership, 1099 terms
7. **Batch Generation** - 50+ offers with compliance checks

## Key Compliance Features

- FLSA classification (exempt/non-exempt)
- Minimum wage validation
- State-specific requirements (CA, CO, NY, TX)
- At-will employment statements
- Contingency clause templates
- Offer expiration handling

## Example Usage

```
Generate an offer letter for Sarah Chen, hiring as Senior Software Engineer
at TechStart Inc. Base salary $180,000, equity grant of 25,000 shares with
standard 4-year vesting/1-year cliff. Role is remote-first. Include 83(b)
election reminder and vesting schedule chart. Strike price to be determined
by Board at grant. Start date March 15, 2025.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
