---
name: invoice-discrepancy-finder
version: 1.0.0
---

# Invoice Discrepancy Finder - Initialization

An intelligent procurement automation skill that automatically matches supplier invoices to corresponding Purchase Orders (POs) and goods receipts, then flags discrepancies for review before payment.

## What This Skill Does

- **3-Way Matching**: Compares Invoice ↔ PO ↔ Goods Receipt to validate orders
- **Discrepancy Detection**: Flags price variances, quantity mismatches, tax errors
- **Duplicate Prevention**: Identifies repeat invoice submissions before payment
- **Exception Routing**: Routes issues to appropriate teams with SLA tracking
- **Fraud Detection**: Catches suspicious patterns and anomalies
- **Early Payment Optimization**: Identifies discount opportunities (2/10 Net 30)
- **Vendor Scorecarding**: Tracks supplier invoice accuracy over time

## Target Users

- Accounts Payable (AP) teams
- Finance controllers
- Procurement teams
- Internal auditors
- ERP administrators (NetSuite, SAP, Oracle, QuickBooks)

## Structure

```
invoice-discrepancy-finder/
├── SKILL.md          # Main skill prompt (copy to AI assistant)
└── INIT.md           # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r invoice-discrepancy-finder/ ~/.claude/skills/invoice-discrepancy-finder/
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction

### Custom GPT

1. Create a new Custom GPT
2. Paste the content of `SKILL.md` into the Instructions field
3. Name it "Invoice Discrepancy Finder"
4. Set conversation starters:
   - "Match this invoice against the PO"
   - "Check if this invoice is a duplicate"
   - "Generate a vendor scorecard"
   - "Analyze early payment discount opportunity"

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{price_variance_tolerance}}` | `2%` | Max % price difference before flagging exception |
| `{{quantity_variance_tolerance}}` | `1 unit` | Max unit difference before flagging exception |
| `{{tax_calculation_tolerance}}` | `0.5%` | Allowable tax calculation variance for rounding |
| `{{high_value_threshold}}` | `$50,000` | Invoices at or above require manual approval |
| `{{duplicate_detection_threshold}}` | `0.5%` | Amount variance considered potential duplicate |
| `{{exception_escalation_days}}` | `2 days` | Days before unresolved exceptions auto-escalate |

## Quick Start Prompts

**Process a standard invoice:**
```
Match invoice #INV-2025-1234 from Acme Corp ($15,750) against PO #PO-2025-0891
(authorized $15,000 for 50 units @ $300/unit) and GRN #GRN-2025-4521 (received
50 units on Dec 10). Flag any discrepancies exceeding ±2% price tolerance.
```

**Check for duplicates:**
```
Check if invoice #INV-2025-5678 from TechSupply Inc for $8,347.92 dated Dec 16
is a duplicate. We may have received this invoice before.
```

**Generate vendor scorecard:**
```
Create a performance scorecard for GlobalParts Ltd for the past 3 months.
Include invoice accuracy rate, exception rate, and tier classification.
```

**Analyze early payment discount:**
```
Analyze payment terms for invoice #INV-2025-9999 with terms "2/10 Net 30".
Invoice amount is $45,600 dated Dec 15. Calculate the discount opportunity
and annualized return.
```

**Review an exception:**
```
Review exception for invoice #INV-2025-4444 showing PRICE_VARIANCE.
PO price was $48/unit but invoice shows $52/unit (8.3% variance).
Recommend resolution options.
```

## Key Workflows

1. **3-Way Matching** - Compare invoice against PO and goods receipt
2. **Duplicate Detection** - Identify repeat submissions
3. **Exception Routing** - Route discrepancies to appropriate teams
4. **Early Payment Capture** - Prioritize discount opportunities
5. **Vendor Scorecarding** - Track supplier performance

## Integration Notes

### ERP Systems

**SAP**: BAPI_PO_GETDETAIL, BAPI_GOODSMVT_CREATE, BAPI_INCOMINGINVOICE_CREATE
**NetSuite**: SuiteTalk API, Item Receipt records, Vendor Bill creation
**Oracle**: REST API for Procurement, Payables Invoice Workbench

### Performance Targets

| Metric | Target |
|--------|--------|
| Straight-Through Processing (STP) | 85-95% |
| Exception Rate | <5% |
| Invoice Accuracy Rate | >95% |
| Resolution Time | <2 days |

## Customization Tips

1. **Adjust tolerances** by vendor tier:
   - Tier 1 (trusted): ±3% price, ±2 units
   - Tier 3 (watch): ±1% price, ±0 units (exact match)

2. **Configure approval thresholds** by organization size:
   - Small business: $10,000 high-value threshold
   - Enterprise: $100,000 high-value threshold

3. **Add industry-specific rules**:
   - Construction: Add retainage tracking
   - Healthcare: Add compliance documentation
   - Manufacturing: Add quality inspection (4-way match)

## Troubleshooting

| Issue | Solution |
|-------|----------|
| High exception rate (>10%) | Review tolerance settings, check PO data quality |
| Missing GRN for valid invoices | Implement GRN reminder workflow |
| Duplicate false positives | Tighten amount tolerance, include PO reference |
| Vendors not including PO numbers | Update vendor onboarding requirements |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
