---
name: inventory-valuation-optimizer
version: 1.0.0
---

# Initialization

Compare LIFO, FIFO, and Weighted Average Cost inventory methods to optimize tax liability, ensure GAAP/IFRS compliance, and make strategic accounting decisions.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive inventory valuation guidance

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r inventory-valuation-optimizer/ ~/.claude/skills/inventory-valuation-optimizer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `inventory_cost_inflation_rate` | `3.5%` | Annual percentage increase in inventory purchase costs |
| `marginal_tax_rate` | `21%` | Company's effective federal marginal income tax rate |
| `accounting_framework` | `US_GAAP` | Applicable accounting standards (US_GAAP, IFRS, or mixed) |
| `inventory_turnover_ratio` | `5.0` | Historical inventory turns per year (COGS / average inventory) |
| `lifo_conformity_required` | `true` | Whether company must use same method for books and tax |
| `write_down_reserve_percentage` | `2.5%` | Estimated percentage of inventory requiring obsolescence write-down |

## Capabilities

1. **Method Comparison Calculator** - Compare LIFO, FIFO, and WAC side-by-side
2. **Tax Impact Analysis** - Quantify tax liability differences and savings
3. **Inflation Sensitivity Modeling** - Stress-test methods against different cost scenarios
4. **Regulatory Compliance Checker** - Validate against GAAP, IFRS, and IRS requirements
5. **LIFO Reserve Tracking** - Calculate and monitor deferred tax liabilities
6. **Method Switch Analysis** - Model impacts of changing valuation methods
7. **Documentation Generator** - Create audit-ready memos and schedules

## Target Audience

- Tax CPAs and accountants
- CFOs and controllers
- Business owners with significant inventory
- Financial analysts and auditors
- Forensic accountants

## Use Cases

### Annual Tax Planning
Analyze whether current method optimizes tax liability given inflation conditions

### Method Switch Decision
Evaluate costs and benefits of switching from LIFO to FIFO or vice versa

### Multinational Consolidation
Reconcile US LIFO operations with IFRS subsidiary reporting

### Compliance Documentation
Generate audit-ready memos supporting method selection rationale

---
Downloaded from [Find Skill.ai](https://findskill.ai)
