---
name: internship-program-designer
version: 1.0.0
---

# Internship Program Designer - Initialization

Design comprehensive internship programs with job descriptions, learning plans, competency frameworks, mentorship structures, and evaluation rubrics aligned with NACE best practices.

## What This Skill Does

The Internship Program Designer helps HR professionals, hiring managers, and academic advisors create structured internship programs that:

- **Craft Compelling Job Descriptions** - Define roles with clear responsibilities, learning objectives, and qualifications that attract qualified candidates
- **Develop Learning Objectives** - Create measurable learning targets across cognitive, skill, and personal growth domains
- **Build Competency Frameworks** - Define expected skills, behaviors, and values at different proficiency levels
- **Structure Mentorship Programs** - Design mentor training, communication protocols, and supervision standards
- **Create Evaluation Rubrics** - Design multi-dimensional assessment tools for mid-term and final evaluations
- **Plan Orientation Programs** - Develop comprehensive onboarding that integrates interns into the organization
- **Measure Program Effectiveness** - Build feedback mechanisms and metrics dashboards for continuous improvement

## Structure

```
internship-program-designer/
├── SKILL.md    # Main skill prompt with 7 design modules
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill). The AI generates all deliverables dynamically based on your organization's context.

## Post-Init Steps

### For Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r internship-program-designer/ ~/.claude/skills/internship-program-designer/

# Verify installation
ls ~/.claude/skills/internship-program-designer/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction
4. Begin by describing your organization and internship goals

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{organization_type}}` | `Mid-size technology company` | Type and size of your organization |
| `{{internship_duration_weeks}}` | `12` | Internship length in weeks (8-16 typical) |
| `{{department_focus}}` | `Software Engineering` | Department or function for intern placement |
| `{{compensation_hourly}}` | `$22.00` | Hourly rate for intern compensation |
| `{{learning_objectives_count}}` | `4` | Number of learning objectives (2-6 recommended) |
| `{{evaluation_frequency}}` | `weekly` | How often mentor-intern check-ins occur |

## Getting Started

After installing the skill, start with a prompt like:

```
I need to design a comprehensive internship program for our marketing department.

Organization: 200-person B2B SaaS company
Duration: 10 weeks (summer)
Positions: 3 marketing interns
Focus areas: Content marketing, social media, analytics
Compensation: $20/hour

Goals:
- Build talent pipeline for entry-level marketing roles
- Achieve 50% intern-to-hire conversion rate
- Develop interns ready for associate-level work

Please help me design the complete program including job descriptions,
learning objectives, competency framework, and evaluation tools.
```

## What You'll Receive

The skill will guide you through 7 modules and can generate:

1. **Complete Job Description** (2-3 pages) - Ready to post
2. **Learning Objective Document** (1-2 pages) - Mapped to domains
3. **Competency Framework** (3-5 pages) - With behavioral indicators
4. **Mentor Training Curriculum** - Session content and materials
5. **Weekly Check-in Template** - Fillable form for mentor-intern meetings
6. **Mid-Term Evaluation Form** (2-3 pages) - With rating scales
7. **Final Evaluation Form** (4-5 pages) - Including hiring recommendation
8. **Orientation Schedule** - Week-by-week agenda
9. **Exit Interview Script** (1-2 pages) - For program feedback
10. **Program Metrics Dashboard** - KPIs and measurement template

## Key Standards Referenced

- **NACE 15 Best Practices** for internship programs
- **Bloom's Taxonomy** for learning objective development
- **Kirkpatrick Model** for program evaluation
- **Competency-Based Development** frameworks

## Tips for Best Results

1. **Provide Context** - Share your organization's culture, values, and goals
2. **Be Specific** - Include target intern profiles and available resources
3. **Iterate** - Review generated content and request adjustments
4. **Think Long-Term** - Consider how the program supports talent strategy

---
Downloaded from [Find Skill.ai](https://findskill.ai)
