---
name: insurance-coverage-auditor
version: 1.0.0
---

# Initialization

Insurance Coverage Auditor - Systematically audit business insurance portfolios to identify coverage gaps, eliminate redundant policies, verify regulatory compliance, and optimize premiums for commercial liability, property, workers' comp, and specialty coverage.

## Structure

- `SKILL.md` - Main skill prompt with complete auditing framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r insurance-coverage-auditor/ ~/.claude/skills/insurance-coverage-auditor/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are an Insurance Coverage Auditor...")
3. Paste into AI assistant as system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_type}}` | `professional services` | Industry sector for insurance requirements assessment |
| `{{employee_count}}` | `25` | Number of employees for workers' comp and liability calculations |
| `{{annual_revenue}}` | `2000000` | Gross annual revenue for coverage limit benchmarking |
| `{{states_of_operation}}` | `CA, TX` | States where business operates for regulatory compliance |
| `{{risk_tolerance}}` | `moderate` | Acceptable gap threshold for coverage recommendations |
| `{{audit_scope}}` | `comprehensive` | Focus area (comprehensive, gaps-only, compliance, cost) |

## Key Features

- **Gap Identification**: Systematic review of liability, property, workers' comp, cyber, and specialty coverage gaps
- **Redundancy Detection**: Matrix-based overlap analysis across multiple policies
- **Compliance Verification**: State regulatory requirements and contractual insurance obligations
- **Premium Optimization**: Deductible optimization, bundling, and experience mod improvement strategies
- **Audit Reporting**: Executive summary and detailed findings templates with severity ratings

## Coverage Categories Analyzed

1. **General Liability** - Premises, products, personal injury
2. **Professional Liability** - E&O, technology, media
3. **Property** - Building, business personal property, business income
4. **Workers' Compensation** - State requirements, experience modification
5. **Commercial Auto** - Owned, hired, non-owned vehicles
6. **Cyber Liability** - First-party and third-party coverage
7. **Umbrella/Excess** - Limits stacking and coordination
8. **Specialty** - Industry-specific coverages (pollution, product recall, etc.)

## Example Usage

```
Audit our manufacturing company's insurance portfolio. We have 120 employees
across CA, TX, and OH facilities. Current coverage: general liability ($1M/$2M),
commercial property ($2.5M), workers' comp (state minimums), product liability
($2M), and commercial auto ($500K). Annual revenue is $15M. We're an automotive
parts supplier with ISO 9001 certification. Recent concerns: 1) Customer contracts
require $5M product liability, 2) We had two workers' comp claims last year,
3) Not sure if we have adequate cyber coverage for our ERP system.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
