---
name: fixed-asset-tracker
version: 1.0.0
---

# Fixed Asset Tracker - Initialization

A comprehensive AI skill for managing fixed assets with depreciation calculations, lifecycle tracking, physical audits, and GAAP/IFRS compliance. Track equipment, vehicles, machinery, and property from acquisition through disposal.

## Target Users

- Financial Controllers and CFOs
- Accountants managing fixed asset ledgers
- Operations and Facilities Managers
- Small/mid-sized business owners
- Non-profit organizations requiring audit compliance
- IT departments tracking technology assets

## Structure

```
fixed-asset-tracker/
├── SKILL.md    # Main skill prompt with full instructions
└── INIT.md     # This initialization file
```

## Files to Generate

None - this is a prompt-only skill. The SKILL.md contains all instructions needed for the AI assistant.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r fixed-asset-tracker/ ~/.claude/skills/fixed-asset-tracker/

# Verify installation
ls ~/.claude/skills/fixed-asset-tracker/
```

### For Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or initial message
4. Begin using with prompts like:
   - "Calculate depreciation for my new equipment"
   - "Help me set up asset tracking for my business"
   - "Plan a physical asset audit"

## Core Capabilities

1. **Asset Registration** - Create comprehensive records with acquisition details, location, custodian assignment
2. **Depreciation Calculation** - All 4 GAAP methods: straight-line, declining balance, units of production, sum-of-years-digits
3. **Lifecycle Tracking** - Monitor from acquisition through maintenance to disposal
4. **Location Tracking** - Track asset movements, check-in/check-out, accountability
5. **Maintenance Analytics** - Log service records, predict failures, calculate total cost of ownership
6. **Financial Reporting** - Balance sheet presentation, depreciation schedules, GAAP/IFRS compliance
7. **Physical Audits** - Variance reporting, reconciliation, missing asset investigation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{capitalization_threshold}}` | `500` | Minimum cost to capitalize as fixed asset (USD) |
| `{{depreciation_method}}` | `straight_line` | Default depreciation method |
| `{{default_useful_life_years}}` | `5` | Standard useful life for equipment |
| `{{salvage_value_percentage}}` | `10` | Default residual value as % of cost |
| `{{audit_frequency_months}}` | `12` | Interval for physical audits |
| `{{maintenance_warning_days}}` | `30` | Days before maintenance due to alert |

## Example Prompts

**Depreciation Calculation:**
```
Calculate the depreciation schedule for our CNC machine:
- Purchase price: $85,000
- Acquired: March 15, 2025
- Useful life: 10 years
- Salvage value: $8,500
- Method: Double declining balance
Show Year 1-5 depreciation and book values.
```

**Asset Disposal:**
```
We're selling our delivery truck (Asset ID: VEH-003):
- Original cost: $45,000
- Purchase date: January 2020
- Accumulated depreciation: $36,000
- Sale price: $12,000
Calculate the gain/loss and provide the journal entry.
```

**Physical Audit:**
```
Plan a quarterly physical audit for our IT equipment across 3 buildings.
We have approximately 250 laptops, 50 desktops, and 30 servers.
What's the most efficient approach?
```

**Maintenance Analysis:**
```
Our hydraulic press has required these repairs:
- 2021: $1,200
- 2022: $1,800
- 2023: $4,500
- 2024: $6,200
Original cost was $55,000 with $5,500 salvage over 10 years.
Should we continue maintaining or replace with a $62,000 new model?
```

## Compliance Standards Covered

- **US GAAP** (ASC 360 - Property, Plant & Equipment)
- **IFRS** (IAS 16 - Property, Plant & Equipment)
- **MACRS** (US Tax Depreciation)
- **Section 179** (Immediate Expensing)
- **Bonus Depreciation** (First-Year Accelerated)
- **SOX Compliance** (Audit Trail Requirements)

## Integration Points

This skill works well alongside:

- General Ledger / Accounting Software
- Inventory Management Systems
- Maintenance Management (CMMS)
- Procurement / Purchase Order Systems
- Tax Preparation Software

## Troubleshooting

**Q: Depreciation schedule shows negative book value**
A: Check that salvage value is properly set and depreciation stops when book value reaches salvage value.

**Q: Gain/loss calculation seems wrong**
A: Verify accumulated depreciation is calculated through the disposal date, not just year-end.

**Q: Should I use GAAP or MACRS depreciation?**
A: Use GAAP (book depreciation) for financial statements and MACRS (tax depreciation) for tax returns. Many businesses maintain both.

---

Downloaded from [Find Skill.ai](https://findskill.ai)
