---
name: exit-interview-generator
version: 1.0.0
---

# Exit Interview Generator - Initialization

Generate customized exit interview questions, compliance-safe scripts, and analysis frameworks for capturing actionable retention insights.

## Skill Overview

This skill transforms you into an expert HR consultant specializing in exit interview processes. You'll help organizations create effective departure conversations that uncover real reasons for leaving while maintaining legal compliance.

### Core Capabilities

1. **Dynamic Question Generation** - Customized questions based on role, tenure, and departure type
2. **Compliance-Safe Scripts** - Questions that avoid legal pitfalls (Title VII, ADA, ADEA)
3. **Interview Conduct Guidance** - Creating psychological safety and effective probing
4. **Analysis Frameworks** - Categorizing and aggregating exit data for patterns
5. **Rehire Assessment** - Identifying boomerang employee potential
6. **Report Generation** - Executive summaries with retention recommendations

## Package Structure

```
exit-interview-generator/
├── SKILL.md      # Main skill prompt (use this)
└── INIT.md       # This file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop

```bash
# Copy to Claude skills directory
cp -r exit-interview-generator/ ~/.claude/skills/exit-interview-generator/
```

Add to Claude Code configuration if using skill aliases:

```json
{
  "skills": {
    "exit-interview": "~/.claude/skills/exit-interview-generator/SKILL.md"
  }
}
```

### ChatGPT / GPT-4

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as system instructions or at conversation start
4. Begin with your exit interview request

### Gemini

1. Open `SKILL.md`
2. Copy the skill content
3. Paste into Gemini and prefix with: "Use these instructions for our conversation:"
4. Describe your exit interview scenario

### Other AI Assistants

1. Open `SKILL.md` in any text editor
2. Copy everything after the YAML frontmatter
3. Paste into your AI assistant's context window
4. Start using immediately

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{interview_mode}}` | `standard` | Question depth: quick (5-7), standard (15-20), full (30+), compliance |
| `{{employee_role}}` | `individual_contributor` | Role level: IC, manager, executive, contract_worker |
| `{{departure_type}}` | `voluntary` | Exit type: voluntary, involuntary, retirement, internal_transfer |
| `{{industry_focus}}` | `general` | Industry: general, healthcare, finance, tech, manufacturing, education |
| `{{output_format}}` | `script` | Deliverable type: script, template, report, dashboard, recommendation |
| `{{data_aggregation_mode}}` | `anonymized` | Analysis scope: anonymized, department_only, manager_level, raw |

## Quick Start Examples

### Example 1: Prepare for Specific Exit Interview

```
I'm conducting an exit interview with Sarah, a Senior Product Designer with 2.5 years
tenure who's leaving for a competitor. She's seemed disengaged recently. Create a
20-question script with tips for building psychological safety.
```

### Example 2: Build Company-Wide Process

```
We're a 200-person tech company with no formal exit interview process. Create:
1. Standard question template (15-20 questions)
2. Quick version for time-constrained situations
3. Compliance checklist for California employment law
4. Analysis framework for tracking patterns
```

### Example 3: Analyze Exit Data

```
I have 35 exit interviews from the past year. Help me create an analysis framework to:
- Categorize departure reasons
- Identify patterns by department and tenure
- Generate an executive summary template
- Recommend retention improvements
```

## Key Features

### Question Categories Covered

- Reasons for leaving (primary drivers)
- Role and responsibilities (job satisfaction)
- Management and leadership (supervisor effectiveness)
- Team and collaboration (workplace relationships)
- Growth and development (career progression)
- Compensation and benefits (total rewards)
- Culture and values (organizational fit)
- Rehire potential (future relationship)

### Script Templates Included

1. **Standard Exit Interview** - 20 questions, 45-60 minutes
2. **Quick Exit Interview** - 7 questions, 15-20 minutes
3. **Compliance-Focused** - Legal-safe format with documentation

### Role-Specific Variations

- Individual Contributors
- People Managers
- Executives
- Contract/Temporary Workers

### Industry Considerations

- Healthcare (HIPAA, staffing)
- Finance (regulatory, compliance)
- Technology (equity, remote work)
- Manufacturing (safety, unions)
- Education (admin burden, development)
- Public Sector (bureaucracy, mission)

## Compliance Coverage

The skill includes guidance for:

- Title VII (discrimination)
- ADA (disability)
- ADEA (age)
- FMLA (leave)
- GDPR/CCPA (data privacy)
- State-specific requirements

## Best Practices Embedded

- Creating psychological safety
- Effective probing techniques
- Handling difficult situations
- Avoiding common interviewer mistakes
- Data aggregation requirements
- Continuous improvement loops

## Related Skills

- **Exit Interview Analyzer** - Process completed interview data
- **Performance Review Generator** - Ongoing feedback documentation
- **Onboarding Checklist Generator** - New hire processes
- **Employee Development Plan Generator** - Career growth planning

## Troubleshooting

### Skill Not Loading

Ensure the SKILL.md file is complete and properly formatted. The frontmatter (between `---` markers) should be valid YAML.

### Questions Feel Generic

Provide more context about:
- Employee's specific role and responsibilities
- Known issues or concerns
- Organizational context and culture
- Desired depth and focus areas

### Compliance Concerns

Always review generated questions with your legal/HR team before use. This skill provides guidance, not legal advice.

---

Downloaded from [Find Skill.ai](https://findskill.ai)
