---
name: esg-impact-auditor
version: 1.0.0
---

# ESG Impact Auditor - Initialization

Comprehensive ESG (Environmental, Social, and Governance) auditing skill for assessing sustainability initiatives, detecting greenwashing, identifying blind spots, and ensuring framework alignment with GRI, SASB, TCFD, ESRS, and CSRD standards.

## Package Structure

```
esg-impact-auditor/
├── SKILL.md          # Main skill prompt (500+ lines)
└── INIT.md           # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Core Capabilities

1. **Materiality Assessment & Double Materiality Evaluation** - Identifies financially material ESG issues alongside impact on environment and society
2. **Framework Alignment Analysis** - Evaluates compliance with GRI, SASB, TCFD, ESRS, CSRD, and IFRS S1/S2
3. **Greenwashing Detection** - Identifies misleading claims using pattern recognition
4. **Blind Spot Identification** - Discovers overlooked ESG risks in governance, supply chains, and emerging issues
5. **Stakeholder Impact Assessment** - Maps stakeholder expectations and evaluates disclosure adequacy
6. **Data Quality & Integrity Audit** - Validates data collection methods and reliability
7. **Industry-Specific Risk Analysis** - Sector-specific ESG challenges and benchmarking

## Post-Init Steps

### Claude Code

```bash
cp -r esg-impact-auditor/ ~/.claude/skills/esg-impact-auditor/
```

### Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the YAML frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or custom instruction

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{audit_scope}}` | `comprehensive` | Scope: comprehensive, environmental, social, governance, or climate_focused |
| `{{applicable_frameworks}}` | `GRI, SASB, TCFD` | ESG frameworks to evaluate against |
| `{{materiality_threshold}}` | `medium_and_above` | Priority filter: all, medium_and_above, or high_only |
| `{{industry_sector}}` | `general` | Industry for benchmarking: energy, finance, retail, pharma, technology, manufacturing, or general |
| `{{assurance_level}}` | `limited` | Audit stringency: limited or reasonable |
| `{{blind_spot_focus_areas}}` | `governance, supply_chain, emerging_risks` | Priority areas for blind spot discovery |

## Example Usage

### Comprehensive Audit

```
Conduct a comprehensive double materiality assessment for a mid-sized fashion retailer with 2,500 employees and global supply chain in South Asia. Focus on GRI and SASB standards. The company reports carbon footprint, water usage, and labour practices but lacks disclosure on circular economy initiatives and supply chain due diligence.
```

### Greenwashing Detection

```
A renewable energy company claims 'net-zero commitment by 2030' but continues heavy investment in fossil fuel infrastructure with minimal near-term emission reduction targets. Analyze their sustainability report for greenwashing red flags including vague language, hidden trade-offs, and unsupported claims.
```

### Industry-Specific Blind Spots

```
A pharmaceutical company reports strong environmental and governance metrics but has minimal social disclosure beyond diversity statistics. Conduct a sector-specific blind spot analysis focusing on drug access and pricing equity, clinical trial ethics, and supply chain traceability.
```

## Target Users

- Sustainability officers and ESG coordinators
- Corporate governance and compliance teams
- Internal and external auditors
- Investors and fund managers
- ESG rating agencies and analysts
- Sustainability consultants and advisors

## Key Frameworks Supported

- **GRI** - Global Reporting Initiative (stakeholder-focused)
- **SASB** - Sustainability Accounting Standards Board (investor-focused)
- **TCFD** - Task Force on Climate-related Financial Disclosures
- **ESRS** - European Sustainability Reporting Standards
- **CSRD** - Corporate Sustainability Reporting Directive
- **IFRS S1/S2** - ISSB Sustainability Standards
- **ISAE 3000** - Assurance engagement standard

---
Downloaded from [Find Skill.ai](https://findskill.ai)
