---
name: employee-survey-analyzer
version: 1.0.0
---

# Employee Survey Analyzer - Initialization

Transform employee engagement survey data into actionable insights with eNPS calculations, departmental segmentation, sentiment analysis, attrition risk identification, and SMART action plans.

## What This Skill Does

This skill turns raw employee survey data into strategic insights for HR professionals, People Ops teams, and company leadership. It provides:

- **eNPS Calculation** - Employee Net Promoter Score with benchmarks
- **Engagement Index** - Composite score across multiple drivers
- **Segmentation Analysis** - Breakdown by department, tenure, role, location
- **Sentiment Analysis** - Theme extraction from open-ended responses
- **Attrition Risk Identification** - Flag at-risk employee groups
- **SMART Action Plans** - Prioritized, actionable recommendations

## Package Structure

```
employee-survey-analyzer/
├── SKILL.md      # Main skill prompt (paste into AI assistant)
└── INIT.md       # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r employee-survey-analyzer/ ~/.claude/skills/employee-survey-analyzer/

# Verify installation
ls ~/.claude/skills/employee-survey-analyzer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as the system prompt or first message

## Usage Examples

### Example 1: Full Annual Survey Analysis

```
I just completed our Q4 employee engagement survey with 400 responses across 8 departments. The data includes:
- 35 Likert scale questions (1-5) covering engagement drivers
- 3 open-ended questions about workplace improvements
- Demographics: department, tenure, role level, location

Please analyze this data and provide:
1. Overall eNPS score and engagement index
2. Top 3 strengths and bottom 3 areas needing improvement
3. Department-by-department breakdown identifying at-risk teams
4. Sentiment analysis of open-ended responses with key themes
5. Executive summary with 3-5 prioritized action areas
```

### Example 2: eNPS Quick Analysis

```
Our eNPS survey had these results:
- 9-10 ratings: 85 employees
- 7-8 ratings: 120 employees
- 0-6 ratings: 45 employees

Calculate the eNPS, interpret the score, and recommend next steps.
```

### Example 3: Department Deep Dive

```
Our Engineering department scored 3.1/5.0 on overall engagement vs company average of 3.8/5.0. Can you help me:
1. Identify which specific drivers are pulling the score down
2. Analyze the 47 open-ended comments from Engineering
3. Create a targeted action plan for the Engineering Director
```

### Example 4: Attrition Risk Assessment

```
We've had 12 resignations in Q4. I have their engagement survey responses from our last survey. Can you help me:
1. Identify patterns in their scores before leaving
2. Flag current employees with similar profiles
3. Create a risk scorecard and retention interventions
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{survey_format}}` | `likert_5_scale` | Rating scale type (likert_5_scale, likert_7_scale, nps_0_10) |
| `{{segmentation_dimensions}}` | `department, tenure, role` | Fields to segment analysis by |
| `{{priority_threshold}}` | `3.5` | Score below which flags as priority (5-point scale) |
| `{{action_plan_focus_areas}}` | `5` | Maximum number of priority recommendations |
| `{{statistical_significance_level}}` | `0.05` | P-value threshold for significance testing |
| `{{sentiment_confidence_threshold}}` | `0.7` | Minimum confidence for sentiment categorization |

## Key Concepts

- **eNPS (Employee Net Promoter Score)** - Measures employee loyalty (0-10 scale)
- **Engagement Index** - Composite score of pride, effort, intent to stay
- **Engagement Drivers** - 12 factors: trust, recognition, growth, etc.
- **Segmentation** - Analysis by department, tenure, role, demographics
- **Pulse Survey** - Short quarterly check-in (8-12 questions)
- **SMART Goals** - Specific, Measurable, Achievable, Relevant, Time-bound

## Best Practices

1. **Segment First** - Company averages hide important variation
2. **Prioritize Ruthlessly** - Maximum 3-5 focus areas
3. **Close the Loop** - Share results transparently with employees
4. **Set Realistic Timelines** - Cultural change takes 6-12+ months
5. **Test Significance** - Don't over-interpret small sample differences

## Related Skills

- [Exit Interview Analyzer](/skills/productivity/exit-interview-analyzer/)
- [Performance Review Generator](/skills/productivity/performance-review-generator/)
- [Employee Development Plan Generator](/skills/industry/employee-development-plan-generator/)
- [KPI Metrics Designer](/skills/data-analytics/kpi-metrics-designer/)
- [Survey Analysis](/skills/data-analytics/survey-analysis/)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
