---
name: employee-handbook-section-writer
version: 1.0.0
---

# Employee Handbook Section Writer - Initialization

Generate professional, legally compliant employee handbook sections covering policies, benefits, culture, code of conduct, compliance, onboarding, and remote work for any organization size.

## Structure

```
employee-handbook-section-writer/
├── SKILL.md      # Main skill prompt with HR documentation expertise
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r employee-handbook-section-writer/ ~/.claude/skills/employee-handbook-section-writer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Provide company details when requesting handbook sections

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{company_size}}` | `medium` | Organization size (startup, small, medium, large, enterprise) |
| `{{work_arrangement}}` | `hybrid` | Primary work model (office, remote, hybrid, flexible) |
| `{{industry_type}}` | `technology` | Industry sector for compliance terminology |
| `{{tone_style}}` | `professional_approachable` | Handbook voice style |
| `{{primary_location}}` | `US_general` | Employee location for legal compliance |
| `{{handbook_focus}}` | `comprehensive` | Output scope (comprehensive, culture_values, policies_only, benefits_focused) |

## Quick Start Examples

### Example 1: Remote Work Policy
```
Generate a comprehensive remote work policy section for a 150-person SaaS
company with employees across 12 countries. Cover eligibility, communication
expectations, equipment provisions, and cybersecurity protocols.
```

### Example 2: Culture Section
```
Create an engaging company culture section for a 40-person AI startup in
San Francisco. Values: innovation, collaboration, ethical AI. Include mission
statement, core values with examples, and life-at-company narrative.
```

### Example 3: Benefits Overview
```
Write a clear compensation and benefits overview for a nonprofit with 60
employees. Cover pay philosophy, health insurance, retirement, PTO, and
professional development. Use plain language with FAQ callouts.
```

## Capabilities

1. **Policy Sections** - Employment classifications, at-will statements, attendance, work hours
2. **Benefits Documentation** - Compensation, health insurance, retirement, PTO policies
3. **Culture Content** - Mission, vision, values, welcome messages, day-in-the-life narratives
4. **Code of Conduct** - Professional standards, ethics, social media, conflict of interest
5. **Compliance Sections** - EEO, anti-harassment, safety, data privacy, FMLA
6. **Onboarding Content** - First day guides, orientation materials, 30-60-90 plans
7. **Remote Work Policies** - Distributed team guidelines, security, equipment, performance

## Legal Compliance Support

The skill includes guidance for:
- Federal requirements (Title VII, ADA, FMLA, OSHA, USERRA)
- State-specific considerations (paid leave, pay transparency, meal breaks)
- International compliance (GDPR, notice periods, works councils)

**Important:** Always have handbook content reviewed by qualified employment law counsel before implementation.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
