---
name: disaster-recovery-plan-generator
version: 1.0.0
description: Generate comprehensive IT disaster recovery plans with NIST SP 800-34 alignment
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides comprehensive IT disaster recovery planning capabilities aligned with NIST SP 800-34. It helps organizations create complete DRP documentation including Business Impact Analysis, risk assessment, backup strategies, failover architectures, recovery runbooks, and testing frameworks.

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
disaster-recovery-plan-generator/
├── SKILL.md    # Main skill instructions with frameworks and templates
└── INIT.md     # This initialization manifest
```

## Dependencies

None - this is a prompt-only skill that works with any AI assistant.

## Files to Generate

None (prompt-only skill) - simply use SKILL.md content directly.

## What This Skill Provides

### Core Capabilities

1. **Business Impact Analysis (BIA)**
   - System criticality classification (5-tier matrix)
   - Financial, operational, regulatory, and reputational impact assessment
   - RTO/RPO target definition methodology
   - Dependency mapping

2. **Risk Assessment**
   - Threat identification and scoring (likelihood × impact)
   - Ransomware-specific readiness checklist
   - Risk response thresholds and mitigation strategies

3. **Recovery Strategy Design**
   - Recovery site comparison (active-active, hot, warm, pilot light, cold)
   - 3-2-1-1-0 backup architecture framework
   - Cloud DR patterns (AWS, Azure, GCP)
   - Multi-region and multi-cloud strategies

4. **Recovery Procedures**
   - Disaster declaration decision tree
   - Recovery runbook templates
   - Ransomware-specific recovery workflow
   - Step-by-step procedures with verification checklists

5. **Testing and Validation**
   - DR test types and frequency matrix
   - Test scenario templates
   - Success criteria definition
   - Metrics tracking dashboard

6. **Governance and Maintenance**
   - Document control procedures
   - Contact and escalation matrices
   - Annual review checklists
   - NIST SP 800-34 phase alignment

### Frameworks and Standards

- **NIST SP 800-34**: Primary framework for IT contingency planning
- **ISO 22301**: Business continuity management alignment
- **ISO 27031**: ICT readiness for business continuity

### Output Formats

- Executive Summary (1-2 pages for leadership)
- Technical DRP Document (20-50 pages comprehensive)
- System-specific Runbooks
- Testing Documentation and Results

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r disaster-recovery-plan-generator/ ~/.claude/skills/disaster-recovery-plan-generator/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Usage Examples

### Example 1: Complete DRP for SaaS Company

```
Create a disaster recovery plan for a SaaS analytics company with:
- 50 employees
- Multi-tenant platform on AWS us-east-1
- PostgreSQL 2TB database with daily S3 backups
- RTO: 2 hours, RPO: 1 hour
- Primary concerns: ransomware, regional cloud outages, database corruption

Include: BIA, risk assessment, backup strategy, failover architecture,
runbooks, and testing schedule.
```

### Example 2: Ransomware Recovery Playbook

```
Generate a ransomware-specific recovery playbook covering:
- Containment procedures
- Impact assessment checklist
- Recovery decision tree (restore vs decrypt vs negotiate)
- Clean restoration workflow
- Post-incident hardening steps

Our environment: Windows Server 2022, VMware ESXi, Veeam backups,
air-gapped tape library.
```

### Example 3: Cloud DR Architecture

```
Design a warm standby DR architecture for our e-commerce platform:
- Primary: AWS us-east-1
- Target RTO: 4 hours
- Target RPO: 1 hour
- Peak load: 50,000 concurrent users
- Tech stack: EKS, Aurora PostgreSQL, ElastiCache, S3

Include: architecture diagrams, failover procedures, cost estimates,
and testing approach.
```

### Example 4: DR Testing Program

```
Create a comprehensive DR testing program for our organization:
- 15 critical systems across 3 data centers
- Regulatory requirements: SOX, PCI-DSS
- Current testing: annual full failover only

Design: test types, frequencies, scenarios, success criteria,
and metrics tracking.
```

## Variables/Parameters

Customize these aspects when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `target_rto_hours` | 4 | Maximum acceptable downtime |
| `target_rpo_minutes` | 60 | Maximum acceptable data loss |
| `recovery_strategy_type` | warm_standby | hot_site, warm_standby, cold_site, cloud_dr |
| `backup_frequency_hours` | 1 | Backup interval to meet RPO |
| `geographic_redundancy` | different_region | same_region, different_region, multi_cloud |
| `testing_frequency_months` | 3 | DR test interval (1=monthly, 3=quarterly) |
| `compliance_framework` | generic | generic, pci_dss, hipaa, gdpr, sox, fedramp |
| `immutable_backup_retention_days` | 30 | Ransomware-proof backup retention |

## Compatibility

Tested and verified with:
- Claude (Sonnet, Opus)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- GitHub Copilot

## Related Skills

This skill works well with:

- **Business Continuity Plan Generator** - Organization-wide continuity planning
- **Crisis Management Plan Generator** - PR and stakeholder communication during crises
- **Risk Register Generator** - Comprehensive risk identification and tracking
- **Vendor Risk Assessment** - Third-party DR capability evaluation
- **Audit Trail Documentation** - Compliance documentation for DR activities

## Version History

| Version | Date | Changes |
|---------|------|---------|
| 1.0.0 | 2025-08-14 | Initial release with NIST SP 800-34 alignment |

---
Downloaded from [FindSkill.ai](https://findskill.ai)
