---
name: crisis-management-plan-generator
version: 1.0.0
---

# Crisis Management Plan Generator - Initialization

Build comprehensive response plans for PR disasters, product recalls, and financial crises with stakeholder communication templates, activation triggers, and recovery strategies.

## Overview

This skill transforms AI assistants into expert crisis management consultants capable of developing complete crisis response plans tailored to any organization type. It covers:

- **Risk Assessment**: Identify and prioritize potential crises using likelihood/impact matrices
- **Team Structure**: Define crisis management team roles and decision authority
- **Response Protocols**: Create activation triggers and first-24-hours checklists
- **Communication Templates**: Ready-to-use statements for employees, customers, media, and regulators
- **Crisis Playbooks**: Specific protocols for PR, product, and financial crises
- **Recovery Frameworks**: Post-crisis recovery and continuous improvement processes

## Structure

```
crisis-management-plan-generator/
├── SKILL.md          # Complete crisis management prompt (700+ lines)
└── INIT.md           # This initialization manifest
```

## Files to Generate

None - this is a prompt-only skill. The `SKILL.md` file contains the complete system prompt for crisis management planning.

## Post-Init Steps

### Claude Code / Claude Desktop
```bash
# Copy to skills directory
cp -r crisis-management-plan-generator/ ~/.claude/skills/crisis-management-plan-generator/
```

### ChatGPT / Custom GPT
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into Custom GPT instructions or start a conversation with the prompt

### Gemini / Other AI Assistants
1. Open `SKILL.md`
2. Copy the complete prompt content
3. Paste as a system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{organization_type}}` | `technology company` | Type of organization (SaaS, retail, financial, healthcare, manufacturing) |
| `{{crisis_type}}` | `data breach` | Primary crisis scenario (PR scandal, product recall, data breach, financial crisis) |
| `{{organization_size}}` | `mid-size (100-500 employees)` | Organization size affecting team structure and channels |
| `{{regulatory_environment}}` | `moderate (GDPR, SOC2)` | Regulatory requirements affecting disclosure timelines |
| `{{stakeholder_priority}}` | `customers first` | Primary stakeholder focus (customers, investors, employees, regulators) |
| `{{response_window}}` | `24 hours` | Target time for initial public response |

## Example Usage

**Prompt**: "Create a crisis management plan for a SaaS company that might face a data breach, including communication templates for customers, employees, regulators, and media, with activation triggers based on severity levels."

**What You'll Get**:
1. Complete risk assessment matrix for SaaS-specific threats
2. Crisis team structure with roles for tech companies
3. Data breach response protocol with GDPR-compliant timelines
4. Ready-to-send notification templates for all stakeholders
5. Severity-based activation triggers (P0-P3)
6. Post-breach recovery and learning framework

## Key Frameworks Included

### Five-Stage Crisis Model
1. **Anticipate** - Pre-crisis risk scanning and scenario planning
2. **Prepare** - Team formation, template creation, simulations
3. **Respond** - Activation triggers, first-24-hours protocol, communication
4. **Recover** - Operational, stakeholder, and reputation recovery
5. **Learn** - Root cause analysis, post-mortem, plan updates

### Three Crisis Playbooks
- **PR/Reputation Crisis**: Executive misconduct, brand scandal, viral backlash
- **Product Crisis**: Recalls, data breaches, safety issues, service outages
- **Financial Crisis**: Cash flow problems, fraud discovery, market collapse

### Communication Templates
- Holding statements (release within 2 hours)
- Detailed response statements (release within 24 hours)
- Employee notifications and all-hands agendas
- Customer notification emails
- Media talking points and Q&A documents

## Skill Capabilities

1. **Generate custom crisis management plans** based on organization profile
2. **Create stakeholder-specific communication templates** for all audiences
3. **Design crisis team structures** with clear roles and authority levels
4. **Develop severity-based activation triggers** for crisis response
5. **Build monitoring dashboards** with metrics and alert thresholds
6. **Plan crisis simulation exercises** with scenario injects
7. **Provide post-crisis recovery frameworks** with success metrics

## Best Practices Applied

- Speed over perfection in initial response
- Single spokesperson for consistent messaging
- Over-communicate internally to employees
- Document everything for legal and learning
- Plan for escalation before it happens
- Balance transparency with legal requirements

---
Downloaded from [Find Skill.ai](https://findskill.ai)
