---
name: board-resolution-generator
version: 1.0.0
---

# Board Resolution Generator - Initialization

Generate legally compliant board resolutions for corporate decisions including executive appointments, financial authorizations, M&A approvals, equity grants, and governance changes with proper WHEREAS/RESOLVED clauses, voting documentation, and certification language.

## Package Structure

```
board-resolution-generator/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Post-Init Steps

### For Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r board-resolution-generator/ ~/.claude/skills/board-resolution-generator/

# Verify installation
ls ~/.claude/skills/board-resolution-generator/
```

### For ChatGPT, Gemini, Copilot, or Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy the content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's custom instructions or system prompt
4. Alternatively, paste directly at the start of a new conversation

### Quick Start

After installation, use prompts like:

```
Create a board resolution for appointing Jane Doe as CEO effective
January 1, 2026. Annual salary $500,000, 50% bonus target, standard
executive benefits. She'll report to the Board. Vote was 7-0 with
1 abstention due to conflict of interest. Meeting was December 15, 2025.
```

```
Generate a resolution authorizing a $10M credit facility with
Bank of America, 5-year term, SOFR + 200bps. CEO and CFO
authorized to negotiate within ±25bps rate variance.
```

```
Draft a special resolution for acquiring TechStartup Inc. for
$25M. Due diligence complete, financing secured. Board voted
8-1 in favor with Director Smith dissenting.
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `company_name` | `Acme Corporation` | Your company's legal name |
| `state_of_incorporation` | `Delaware` | State/jurisdiction of incorporation |
| `resolution_type` | `ordinary` | ordinary, special, or written consent |
| `meeting_format` | `virtual` | in-person, virtual, or hybrid |
| `output_format` | `formal` | formal, startup-lean, or template-ready |

## Resolution Types Supported

| Type | Voting Threshold | Use Cases |
|------|------------------|-----------|
| Ordinary | >50% majority | Executive appointments, budgets, contracts, policies |
| Special | 75%+ supermajority | M&A, bylaw changes, capital structure, dissolution |
| Written Consent | Unanimous | Urgent matters between meetings |

## Key Outputs

- **Complete Resolution Document**: WHEREAS clauses, RESOLVED clauses, voting record
- **Signature Blocks**: Board chair and corporate secretary
- **Certification Language**: Secretary attestation for third-party use
- **Compliance Checklist**: Pre/post-resolution verification

## Customization

The skill adapts to:
- **Company Types**: C-Corp, S-Corp, LLC, Nonprofit
- **Jurisdictions**: Delaware (default), California, New York, International
- **Formality Levels**: Formal, Startup-Lean, Template-Ready
- **Output Formats**: PDF-ready, Word-editable, HTML, Plain Text

## Example Workflow

1. **User provides**: Decision type + details + meeting info + vote count
2. **AI generates**: Complete resolution with all required sections
3. **User reviews**: Verify accuracy, customize placeholders if any
4. **Execute**: Print, obtain signatures, file in corporate records

## Best Practices

- Always specify exact dollar amounts (written + numeric)
- Name authorized signatories by name and title
- Include abstentions with reasons (especially for COI)
- Use resolution numbering (YYYY-XXX format)
- Retain signed originals for 10+ years

## Compliance Notes

- **Public Companies**: Skill includes SEC Form 8-K and proxy disclosure guidance
- **Related Party Transactions**: Skill prompts for extra disclosure and abstention
- **409A Compliance**: Equity grants include valuation reference requirements
- **Bylaw Verification**: Skill reminds to check voting thresholds per bylaws

---
Downloaded from [Find Skill.ai](https://findskill.ai)
