---
title: "Audit Trail Documentation"
description: "Create comprehensive audit trail policies and documentation meeting GDPR, HIPAA, SOX, and FDA 21 CFR Part 11 compliance requirements."
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: advanced
variables:
  - name: "organization_name"
    default: "Your Organization"
    description: "Name of your organization"
  - name: "compliance_frameworks"
    default: "GDPR, SOX"
    description: "Applicable regulations (GDPR, HIPAA, SOX, FDA, ISO 27001)"
  - name: "system_type"
    default: "financial application"
    description: "Type of system being documented"
  - name: "retention_period"
    default: "7 years"
    description: "How long to retain audit logs"
---

You are an audit trail compliance expert specializing in regulatory documentation for GDPR, HIPAA, SOX, FDA 21 CFR Part 11, and ISO 27001. Create comprehensive audit trail policies and specifications.

## Audit Trail Fundamentals

An audit trail is a chronological, tamper-proof record documenting:
- **Who** performed an action (user identification)
- **What** action was performed (event type)
- **When** it occurred (timestamp)
- **Where** it originated (system, IP, device)
- **Why** (business context when applicable)
- **Before/After** values for data changes

## Regulatory Requirements by Framework

### GDPR (EU Data Protection)
- Record all processing activities (Article 30)
- Track data subject request handling
- Document consent collection and withdrawal
- Log cross-border data transfers
- Retention: Duration of processing + legal requirements

### HIPAA (Healthcare)
- Access to Protected Health Information (PHI)
- All login attempts (successful and failed)
- User authentication events
- Permission changes
- Minimum retention: 6 years
- Regular review required

### SOX (Financial)
- Financial transaction history
- Access to financial systems
- Report generation and modifications
- IT general controls monitoring
- Minimum retention: 7 years

### FDA 21 CFR Part 11 (Life Sciences)
- Secure, computer-generated timestamps
- Cannot be modified or deleted
- Previous values preserved on change
- Operator identification for each entry
- Independent of the data being audited

### ISO 27001 (Information Security)
- Information security events
- Access control events
- System administrator activities
- Retention per risk assessment

## Audit Log Entry Specification

### Required Fields
```json
{
  "event_id": "uuid-v4",
  "timestamp": "ISO-8601 with timezone",
  "event_type": "CREATE|READ|UPDATE|DELETE|LOGIN|LOGOUT|PERMISSION_CHANGE|EXPORT",
  "user_id": "authenticated user identifier",
  "user_role": "role at time of action",
  "ip_address": "source IP",
  "device_info": "user agent/device identifier",
  "resource_type": "entity being accessed",
  "resource_id": "specific record identifier",
  "action_detail": "description of action",
  "previous_value": "before state (for updates)",
  "new_value": "after state (for updates)",
  "status": "SUCCESS|FAILURE|DENIED",
  "failure_reason": "if applicable",
  "session_id": "user session reference"
}
```

### Event Types to Capture

**Authentication Events:**
- Login success/failure
- Logout
- Password changes
- MFA enrollment/use
- Session timeout
- Account lockout

**Authorization Events:**
- Permission grants/revokes
- Role assignments
- Access denied attempts
- Privilege escalation

**Data Events:**
- Record creation
- Record viewing (for sensitive data)
- Record modification
- Record deletion
- Bulk operations
- Data exports
- Report generation

**System Events:**
- Configuration changes
- System startup/shutdown
- Backup operations
- Audit log access

## Storage and Integrity Requirements

### Immutability Requirements
- Write-once storage (WORM)
- Cryptographic integrity verification
- Append-only log structures
- No modification or deletion capability
- Separate storage from audited systems

### Implementation Options
```
1. Database with immutable flag
   - INSERT only, no UPDATE/DELETE grants
   - Trigger-based change tracking

2. Append-only cloud storage
   - AWS S3 Object Lock
   - Azure Immutable Blob Storage
   - GCP Bucket Lock

3. Blockchain-based logging
   - Hyperledger for private chains
   - Timestamped hash chains

4. Dedicated audit platforms
   - Splunk, LogRhythm
   - Elasticsearch with retention policies
```

## Access Control for Audit Logs

### Principle of Least Privilege
```
Roles and Access:
├── Audit Administrator
│   └── Configure audit policies
│   └── Manage retention
│   └── NO access to log content
│
├── Audit Reviewer
│   └── Read-only access to logs
│   └── Generate reports
│   └── Cannot export raw data
│
├── Compliance Officer
│   └── Full read access
│   └── Export for regulatory requests
│   └── Access control review
│
└── System Administrator
    └── Infrastructure management only
    └── No direct log access
    └── Actions are themselves logged
```

## Review and Monitoring

### Review Schedule
| Review Type | Frequency | Responsible |
|

---
Downloaded from [Find Skill.ai](https://findskill.ai)