---
name: audit-trail-documentation
version: 1.0.0
---

# Initialization

Create comprehensive audit trail policies and documentation meeting GDPR, HIPAA, SOX, and FDA 21 CFR Part 11 compliance requirements.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r audit-trail-documentation/ ~/.claude/skills/audit-trail-documentation/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{organization_name}}` | `Your Organization` | Name of your organization |
| `{{compliance_frameworks}}` | `GDPR, SOX` | Applicable regulations (GDPR, HIPAA, SOX, FDA, ISO 27001) |
| `{{system_type}}` | `financial application` | Type of system being documented |
| `{{retention_period}}` | `7 years` | How long to retain audit logs |

---
Downloaded from [Find Skill.ai](https://findskill.ai)