---
name: accounting-close-checklist-generator
version: 1.0.0
---

# Accounting Close Checklist Generator - Initialization

Generate customized month-end and year-end financial close checklists with task sequencing, deadlines, reconciliation procedures, and audit-ready documentation for accounting teams.

## What This Skill Does

This skill creates comprehensive close checklists tailored to your organization's size, industry, regulatory requirements, and timeline targets. It covers:

- Month-end, quarter-end, and year-end close processes
- Task assignment with C+N deadline notation
- Reconciliation procedures for all account types
- Multi-entity consolidation workflows
- Audit-ready documentation requirements
- Best practices and common pitfalls

## Structure

```
accounting-close-checklist-generator/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
├── INIT.md     # This initialization file
└── index.md    # Hugo page (for website display only)
```

## Files to Generate

None (prompt-only skill). The AI generates checklists dynamically based on your inputs.

## Post-Init Steps

### Claude Code (Recommended)

```bash
# Copy skill to Claude Code skills directory
cp -r accounting-close-checklist-generator/ ~/.claude/skills/accounting-close-checklist-generator/

# Verify installation
ls ~/.claude/skills/accounting-close-checklist-generator/
```

Then reference the skill in Claude Code conversations.

### ChatGPT / Claude.ai / Gemini / Other AI Assistants

1. Open `SKILL.md` in this package
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into a new conversation with your AI assistant
4. Begin by describing your organization's close requirements

### Custom GPT / Claude Project

1. Create a new Custom GPT or Claude Project
2. Paste the SKILL.md content as system instructions
3. Name it "Accounting Close Checklist Generator"
4. Use for recurring close checklist generation

## Variables

Customize these variables when generating checklists:

| Variable | Default | Description |
|----------|---------|-------------|
| `close_type` | `month_end` | Type of close: `month_end`, `quarter_end`, `year_end` |
| `organization_size` | `mid_market` | Business size: `small` (1-20 staff), `mid_market` (20-100), `enterprise` (100+) |
| `num_entities` | `1` | Number of legal entities requiring consolidation |
| `close_days_target` | `10` | Target business days to complete close |
| `regulatory_compliance` | `general` | Requirements: `general`, `non_profit`, `public_company` |
| `automation_level` | `manual` | Current capability: `manual`, `partial`, `automated` |

## Example Usage

```
Generate a month-end close checklist for a 15-person accounting department
at a 200-employee manufacturing company with 3 locations. We use QuickBooks
Online. Target close timeline is 8 business days. Include task owners,
deadlines, and pre-close preparation tasks.
```

```
Create a year-end close checklist for a mid-market professional services
firm planning external audit in January. We have a 1-year fiscal year
ending 12/31. Include revenue/AR review, fixed asset audit prep, tax
return prep tasks, and documentation requirements.
```

```
Build a consolidated month-end close checklist for a parent company with
4 subsidiary entities. Include intercompany reconciliation steps,
elimination journal entries, and sequence showing which entity closes first.
```

## Key Concepts Covered

- **C+N Notation**: Close Day + N business days deadline system
- **Reconciliation**: Matching GL to external statements
- **Trial Balance**: Debit/credit verification before statements
- **Adjusting Entries**: Accruals, depreciation, prepaids
- **Cut-Off**: Transaction timing boundaries
- **Intercompany Elimination**: Multi-entity consolidation

## Workflow Templates Included

1. **Standard Month-End (8-10 days)** - Full close with phases
2. **Year-End Close (4-6 weeks)** - Extended with tax/audit prep
3. **Multi-Entity Consolidation** - Intercompany processing
4. **Quick Close (3-5 days)** - Accelerated with automation

## Best Practices Embedded

- Continuous reconciliation throughout month
- Pre-close preparation activities
- Clear task ownership assignment
- Second reviewer requirements
- Balance sheet prioritization
- Documentation standards

## Troubleshooting

The skill includes resolution steps for common issues:
- Bank reconciliation imbalances
- Intercompany mismatches
- Trial balance discrepancies
- Extended close cycles

## Related Skills

After generating close checklists, consider these complementary skills:

- **Budget Variance Analyzer** - Analyze closed period variances
- **Cash Flow Projection Generator** - Forecast from actuals
- **Financial Ratio Analyzer** - Calculate key ratios
- **Audit Trail Documentation** - Compliance documentation

---
Downloaded from [Find Skill.ai](https://findskill.ai)
