---
name: 30-60-90-day-onboarding-roadmap
version: 1.0.0
---

# Initialization

Generate role-specific 30-60-90 day onboarding roadmaps with milestones, metrics, buddy assignments, and manager check-in schedules. Supports sales, technical, management, customer success, and HR roles with customizable experience levels and learning paces.

## Structure

- `SKILL.md` - Main skill prompt with complete onboarding framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r 30-60-90-day-onboarding-roadmap/ ~/.claude/skills/30-60-90-day-onboarding-roadmap/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "You are an expert HR strategist...")
3. Paste into your AI assistant as a system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{hire_role}}` | `individual_contributor` | Role type: sales_rep, software_engineer, customer_success_manager, manager, hr_specialist |
| `{{experience_level}}` | `mid_level` | Experience: entry_level, mid_level, senior, executive |
| `{{onboarding_duration_days}}` | `90` | Total onboarding period (60-120 typical) |
| `{{learning_pace}}` | `standard` | Speed: accelerated, standard, extended |
| `{{team_size_reporting}}` | `0` | Number of direct reports (for managers) |
| `{{include_metrics_tracking}}` | `true` | Generate quantified KPIs and success measures |

## Quick Start Examples

### Sales Representative (Entry-Level)
```
Create a 90-day onboarding roadmap for an entry-level Sales Development
Representative joining our B2B SaaS company. They have no prior sales
experience. We use Salesforce CRM. Include daily activities for week 1,
weekly goals, and success metrics at 30/60/90 days.
```

### Software Engineer (Mid-Level)
```
Generate a 90-day onboarding plan for a mid-level backend engineer joining
our platform team. They have 4 years Python experience but are new to our
Node.js/PostgreSQL stack. They should be shipping code by week 4 and fully
ramped by day 90.
```

### Engineering Manager (Senior)
```
Create a 120-day onboarding roadmap for a new Engineering Manager inheriting
a team of 8 developers. They're senior-level with 3 years management
experience but new to our product. Include leadership activities, team
assessment, and 1-on-1 schedules.
```

### Customer Success Manager
```
Build a 90-day plan for a Customer Success Manager who will manage 15
enterprise accounts ($5M+ ARR). They have CSM experience but need to learn
our product. Include account transition plan, QBR preparation, and
expansion targets.
```

## Output Format

The skill generates structured roadmaps with:
- Executive summary with key success metrics
- Phase-by-phase breakdown (Learn → Contribute → Execute)
- Daily/weekly activity checklists
- Manager check-in schedules and templates
- Buddy system implementation guide
- Success metrics and KPIs for each milestone
- 30/60/90 day review templates

## Role Templates Included

1. **Sales Representative** - Prospecting, pipeline, quota ramp
2. **Software Engineer** - Environment setup, code contributions, feature ownership
3. **Manager/Leadership** - Team assessment, process improvement, strategic planning
4. **Customer Success** - Account ownership, renewals, expansion
5. **HR/People Operations** - Recruiting, compliance, onboarding (meta!)

## Best Practices

- Always customize for the specific role and company context
- Include measurable success metrics at each milestone
- Assign a buddy separate from the direct manager
- Schedule consistent check-ins (more frequent early, tapering over time)
- Document everything for future onboarding iterations
- Gather feedback and iterate on the program

---
Downloaded from [Find Skill.ai](https://findskill.ai)
