---
name: sublet-vetting-protocol
version: 1.0.0
---

# Sublet Vetting Protocol - Initialization Guide

Comprehensive tenant screening framework for subletting your apartment safely. This skill provides credit check guidance, reference verification scripts, fraud detection protocols, and legal documentation templates.

## What This Skill Does

- Creates custom screening criteria based on your property and risk tolerance
- Provides application forms, verification scripts, and agreement templates
- Detects red flags and fraud indicators in potential subtenants
- Generates move-in inspection checklists and video documentation protocols
- Drafts legally-sound sublease agreements with damage liability clauses
- Guides you through the complete vetting process step-by-step

## Package Contents

```
sublet-vetting-protocol/
├── SKILL.md          # Main skill prompt (copy this to your AI)
└── INIT.md           # This initialization guide
```

## Installation

### Claude Code / Claude Desktop

```bash
# Copy skill to Claude skills directory
cp -r sublet-vetting-protocol/ ~/.claude/skills/sublet-vetting-protocol/
```

Then reference in your Claude configuration or use directly.

### ChatGPT / GPT-4

1. Open `SKILL.md` in a text editor
2. Copy everything after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a Custom Instruction or at the start of your conversation

### Gemini

1. Open `SKILL.md`
2. Copy the skill content
3. Paste at the beginning of your Gemini conversation

### Copilot

1. Open `SKILL.md`
2. Copy the full prompt content
3. Use as a system message or conversation starter

## Variables

Customize these values based on your requirements:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{credit_score_minimum}}` | `650` | Minimum credit score for approval |
| `{{income_multiplier}}` | `3.0` | Required income-to-rent ratio (3.0 = income 3x rent) |
| `{{background_check_years}}` | `7` | Years of history to review in background check |
| `{{security_deposit_months}}` | `1.0` | Security deposit as multiple of monthly rent |
| `{{insurance_liability_minimum}}` | `1000000` | Minimum tenant liability insurance in USD |
| `{{sublease_duration_days}}` | `30` | Minimum sublease duration in days |

## Example Usage

After installing, start a conversation with:

```
I'm subletting my 2-bedroom apartment in Brooklyn for 8 months while
I'm abroad for work. The rent is $2,400/month and I have expensive
furniture and electronics. Can you help me create a complete vetting
process including application requirements, credit score minimums,
reference verification scripts, and a sublease agreement template?
```

The AI will:
1. Ask clarifying questions about your specific situation
2. Create custom screening criteria for your property
3. Provide application forms and verification scripts
4. Generate a sublease agreement template
5. Guide you through the full vetting process

## Templates Included

The skill can generate these documents on request:

- **Sublease Application Form** - Collects applicant info, employment, rental history
- **Landlord Reference Call Script** - Questions to ask previous landlords
- **Employment Verification Script** - Questions for HR departments
- **Move-In Condition Checklist** - Room-by-room inspection form
- **Video Walkthrough Protocol** - Step-by-step documentation guide
- **Fraud Detection Checklist** - Red flags and verification steps
- **Sublease Agreement Template** - Full legal agreement with damage clauses

## Key Features

### Financial Screening
- Credit score analysis and decision matrix
- Income-to-rent ratio verification
- Payment history evaluation

### Reference Verification
- Landlord reference call scripts
- Employment verification procedures
- Building management contact strategies

### Fraud Detection
- Red flag identification checklist
- Airbnb scam detection
- Payment safety protocols

### Legal Documentation
- Fixed-term sublease agreements
- Damage liability clauses
- Insurance requirements

### Move-In Protection
- Video documentation protocol
- Written condition forms
- Evidence preservation

## Tips for Best Results

1. **Be specific** about your property details, rent amount, and duration
2. **Share your concerns** - the AI will customize recommendations accordingly
3. **Ask for templates** - request specific documents as you need them
4. **Request jurisdiction guidance** - laws vary by state/province
5. **Iterate on agreements** - ask for modifications to fit your situation

## Related Skills

- Roommate Agreement Drafter - For shared living arrangements
- Security Deposit Reclaimer - For recovering deposits when moving out
- Contract Analyzer - For reviewing lease terms
- Negotiation Stance Builder - For rent negotiation situations

---
Downloaded from [Find Skill.ai](https://findskill.ai)
