---
name: security-deposit-reclaimer
version: 1.0.0
---

# Initialization

Security Deposit Reclaimer helps tenants recover unreturned or wrongfully withheld security deposits by generating legally compliant demand letters customized to their specific jurisdiction, with state-specific laws, legal codes, and treble damages calculations.

## Structure

- `SKILL.md` - Main skill prompt with 50-state coverage, demand letter workflows, and legal templates

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r security-deposit-reclaimer/ ~/.claude/skills/security-deposit-reclaimer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant's system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `tenant_state` | `CA` | Two-letter state code determining applicable statutes and timelines |
| `deposit_amount` | `1500` | Dollar amount of the security deposit |
| `moveout_date` | `2024-01-15` | Date tenant vacated the property (YYYY-MM-DD) |
| `dispute_type` | `full_nonreturn` | Category: full_nonreturn, partial_return, disputed_deductions, illegal_deposit |
| `landlord_entity_type` | `individual` | Type: individual, management_company, national_chain |
| `send_method` | `certified_mail` | Delivery method: certified_mail, email_certified, hand_delivery |

## Core Capabilities

1. **State-Specific Template Generation** - Automatically select applicable state laws and generate customized demand letters with correct legal codes and timelines

2. **Multi-Jurisdiction Support** - Handle variations across all 50 US states, plus international options (Canada, UK) with distinct deposit protection schemes

3. **Timeline Calculation** - Calculate legal deadlines based on move-out date; alert when critical windows for action are closing; determine treble damages eligibility

4. **Damage Dispute Language** - Generate specific language for disputing itemized deductions based on legal standards (normal wear and tear, excessive pricing, pre-existing damage)

5. **Penalty Multiplier Identification** - Identify whether the tenant qualifies for double/treble damages (2x, 3x, or more) based on landlord violations

6. **Certification & Service Documentation** - Guide users on proper delivery methods (certified mail, return receipts, proof of service)

7. **Pre-Litigation Escalation Path** - Provide escalation sequence (initial demand -> follow-up demand -> small claims pre-filing notice)

## State Deadline Quick Reference

| Days | States |
|------|--------|
| 14 | NY, NE, AZ, VT, HI, AK, SD |
| 21 | CA, WA, MN, WI, ID |
| 30 | TX, FL, IL, GA, OH, NC, MI, NJ, NV, IA, NM, SC, ME, NH, LA, KS, ND, MT |
| 45 | VA, OK, MS, IN, DC |
| 60 | CO, AR |

## Usage Example

```
User: I moved out of my apartment in Los Angeles, California on January 15, 2024,
and paid a $1,500 security deposit. It's now February 20, 2024, and the landlord
hasn't returned my deposit or sent any itemized list. Can you generate a demand letter?

AI: [Generates California-specific demand letter citing Civil Code § 1950.5,
calculating 36 days elapsed (15 days past deadline), noting landlord forfeited
right to deductions, demanding full $1,500 return within 14 days, with 2x
damages warning and certified mail instructions]
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
