---
name: roommate-interview-guide
version: 1.0.0
---

# Initialization

Comprehensive roommate interview framework with 60+ questions to assess compatibility in cleanliness, noise, finances, and lifestyle before signing a lease. Includes red flag detection, green flag indicators, scoring systems, reference check templates, and in-person assessment guides.

## Structure

- `SKILL.md` - Main skill prompt with complete interview guide

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r roommate-interview-guide/ ~/.claude/skills/roommate-interview-guide/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{interview_focus}}` | `comprehensive` | Focus area (comprehensive, cleanliness, noise, finances) |
| `{{living_situation}}` | `apartment` | Type of housing (apartment, house, dorm) |
| `{{number_of_roommates}}` | `1` | Number of roommates being interviewed |
| `{{top_concerns}}` | `cleanliness, noise, finances` | User's priority concerns |
| `{{experience_level}}` | `first-time` | User's roommate experience level |

## Quick Start Examples

### Example 1: First-Time Roommate Seeker
```
I'm interviewing someone this weekend to share my 2-bedroom apartment.
I've never had a roommate before. My main concerns are:
1. I'm a light sleeper and work from home
2. I'm fairly neat and hate dirty dishes
3. I want to make sure they can reliably pay rent

Give me the most important questions to ask and what red flags to watch for.
```

### Example 2: Reference Check Help
```
I just interviewed a potential roommate who seemed great. They gave me
two references - a previous roommate and a landlord. What specific
questions should I ask each of them to verify what they told me?
```

### Example 3: Red Flag Assessment
```
I interviewed someone yesterday and I'm not sure about some of their answers:
- They said they're "very clean" but couldn't name any cleaning products
- They mentioned 3 previous roommates in 2 years
- They got defensive when I asked about income verification

Help me evaluate whether these are red flags or if I'm overthinking it.
```

### Example 4: In-Person Visit Prep
```
I'm going to visit a potential roommate's current apartment tomorrow.
What should I specifically look for to assess their actual cleanliness
and living habits beyond what they told me in the interview?
```

## Key Capabilities

1. **Interview Question Generator** - 60+ questions across 4 categories
2. **Red Flag Detector** - Warning signs in answers and behavior
3. **Green Flag Recognizer** - Positive compatibility indicators
4. **Compatibility Scorer** - Weighted scoring system (60 points max)
5. **Reference Check Guide** - Questions for landlords and previous roommates
6. **In-Person Assessment Coach** - What to observe when visiting their space
7. **Agreement Topic Identifier** - Issues to document before move-in

## Interview Categories

| Category | Questions | Focus Areas |
|----------|-----------|-------------|
| Cleanliness | Q1-Q10 | Cleaning habits, kitchen, bathroom, pest awareness |
| Noise & Schedule | Q11-Q23 | Sleep schedule, hobbies, guests, substances |
| Financial | Q24-Q28 | Income, payment history, debt, reliability |
| Lifestyle | Q29-Q38 | Communication, conflicts, housing history |

## Scoring System Overview

| Score Range | Interpretation |
|-------------|----------------|
| 48-60 | Excellent match - proceed with confidence |
| 36-47 | Good match - minor concerns to discuss |
| 24-35 | Moderate concerns - proceed with caution |
| Below 24 | Poor match - likely significant problems |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
