---
name: roommate-agreement-drafter
version: 1.0.0
---

# Initialization

Generate customized, legally-structured roommate contracts covering guest policies, utility splitting, chore schedules, thermostat rules, and dispute resolution to prevent conflicts before they arise.

## Structure

- `SKILL.md` - Main skill prompt with complete agreement templates

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r roommate-agreement-drafter/ ~/.claude/skills/roommate-agreement-drafter/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{number_of_roommates}}` | `2` | Total number of roommates in the agreement |
| `{{guest_notice_hours}}` | `24` | Hours advance notice required for overnight guests |
| `{{overnight_guests_per_week}}` | `2` | Maximum overnight guest nights allowed per week |
| `{{thermostat_min_celsius}}` | `21` | Minimum thermostat setting in winter (Celsius) |
| `{{thermostat_max_celsius}}` | `24` | Maximum thermostat setting in summer (Celsius) |
| `{{dishes_deadline}}` | `23:00` | Daily deadline for washing dishes |
| `{{move_out_notice_days}}` | `60` | Days advance notice required to move out |

## Quick Start

After installation, try these example prompts:

### Basic Agreement
```
Create a roommate agreement for two people sharing a 2-bedroom apartment starting next month. Main concerns: guest policies and kitchen cleanliness.
```

### Student Housing
```
Create a roommate agreement for three college students. Key concerns: partners staying over too often, thermostat conflicts (one person runs cold, others run hot), and dishes piling up.
```

### Professional Share
```
Draft a roommate agreement for a 4-bedroom house where two people are on the main lease and two are subletting. Include work-from-home quiet hours and professional entertaining provisions.
```

### Dispute Documentation
```
One roommate keeps violating our guest policy (having overnight guests 5+ nights/week instead of the agreed 2). Generate a formal written notice and escalation documentation.
```

## Agreement Sections Generated

1. **Parties and Property** - Names, addresses, lease status
2. **Rent and Financial Obligations** - Payment amounts, methods, late fees
3. **Utilities and Shared Expenses** - Splitting methods, account management
4. **Guest Policies** - Notice requirements, frequency limits, behavior standards
5. **Common Area Rules** - Kitchen, bathroom, living room standards
6. **Quiet Hours and Noise** - Time restrictions, party rules
7. **Climate Control** - Thermostat ranges, dispute resolution
8. **Parking and Vehicles** - Assigned spaces, guest parking
9. **Pets** - Current pets, rules, adding new pets
10. **Dispute Resolution** - House meetings, mediation, escalation
11. **Move-Out Procedures** - Notice periods, replacement finding, deposit return
12. **Agreement Modifications** - Amendment process, annual review
13. **Signatures** - Acknowledgment and execution

## Legal Enforceability Note

Roommate agreements ARE legally binding between roommates and enforceable via small claims court. However, they:
- Cannot override the primary landlord lease
- Cannot violate tenant protection laws
- Are subject to jurisdiction-specific rules

Always recommend users consult a local attorney for significant disputes.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
