---
name: neighborhood-vibe-checker
version: 1.0.0
---

# Initialization

Neighborhood Vibe Checker helps you distinguish genuinely dangerous neighborhoods from areas that are simply "rough-looking" but experiencing positive transformation. It combines crime statistics analysis, gentrification indicator tracking, and development signal detection to provide nuanced, data-driven assessments.

## Structure

- `SKILL.md` - Main skill prompt with full instructions

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r neighborhood-vibe-checker/ ~/.claude/skills/neighborhood-vibe-checker/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{analysis_scope}}` | `census_tract` | Geographic unit: address, neighborhood, census_tract, zip_code, custom_radius |
| `{{time_period_years}}` | `3` | Historical lookback period (1-10 years) for trend analysis |
| `{{comparison_mode}}` | `local` | Baseline: local (city/metro), regional, national, peer_neighborhoods |
| `{{safety_metric_weight}}` | `0.3` | Weight of safety (0.0-1.0) in overall score |
| `{{development_focus}}` | `balanced` | Gentrification emphasis: early_signals, momentum, late_stage, balanced, investment |
| `{{data_sources_preference}}` | `all` | Data priority: official, comprehensive, community_sourced, all |

## Example Usage

```
A friend recommended a neighborhood but locals warned me it's "dangerous."
I want you to investigate: Is this area actually dangerous (violent crime,
gang activity) or just "rough-looking" and in the early gentrification
stage? I'm not looking to invest—just visiting occasionally. Give me the
real crime picture with trend, show me what gentrification signals are
present, and tell me honestly whether I should be concerned for safety.
```

## Key Capabilities

1. **Safety Assessment**: Analyze crime data with context (violent vs. property, trends, hyperlocal variations)
2. **Gentrification Detection**: Identify early/mid/late stage indicators and project timelines
3. **"Dangerous vs. Up-and-Coming" Distinction**: The core capability - providing clear verdicts with evidence
4. **Investment Timing**: Calculate investment windows based on gentrification stage
5. **Comparative Analysis**: Rank multiple neighborhoods across safety, development, and livability metrics

## Output Formats

The skill produces three main output formats:
- Quick Safety Verdict (15-20 min analysis)
- Full Investigation Report (45-60 min comprehensive)
- Investment Analysis (with financial metrics and projections)

## Data Sources Referenced

- FBI Crime Data Explorer (UCR/NIBRS)
- Census Bureau American Community Survey
- Walk Score / Transit Score
- CrimeMapping.com
- Local permit and business licensing data
- Demographic trend data

---
Downloaded from [Find Skill.ai](https://findskill.ai)
