---
name: moving-box-estimator
version: 1.0.0
---

# Initialization

Calculate exactly how many moving boxes you need for a 1-bedroom apartment. Get room-by-room breakdowns, optimal size recommendations, and a strategic packing plan that prevents the chaos of running out of boxes on moving day.

## Structure

- `SKILL.md` - Main skill prompt with estimation workflows, box size guides, and packing strategies

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r moving-box-estimator/ ~/.claude/skills/moving-box-estimator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# Moving Box Estimator")
3. Paste into AI assistant as system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{apartment_sqft}}` | `650` | Total square footage of your 1-bedroom apartment |
| `{{furnishing_level}}` | `average` | How much stuff you have: minimalist, average, or maximalist |
| `{{years_resident}}` | `3` | How long you've lived in the current apartment |
| `{{num_residents}}` | `1` | Number of people living in the apartment |
| `{{buffer_percentage}}` | `0.15` | Safety margin for extra boxes (industry standard is 15%) |
| `{{purge_aggressiveness}}` | `none` | How much you plan to declutter: none, mild, moderate, or aggressive |

## Quick Start

After installation, use prompts like:

- "I'm moving out of my 700 sq ft apartment where I've lived for 4 years. How many boxes do I need?"
- "Give me a room-by-room breakdown for packing my 1-bedroom. I have lots of books."
- "I'm moving in 2 weeks - what's the minimum supplies I need for an emergency move?"
- "Calculate the volume and weight of my move for getting quotes from movers"
- "I need to fit everything in a 15-ft truck. Will 50 boxes fit?"

## Example Output

```
================================
MOVING BOX ESTIMATE
================================

Apartment: 650 sq ft, 3 years residence
Furnishing: Average
Residents: 1

TOTAL BOXES NEEDED: 52-60 (includes 15% buffer)

BREAKDOWN BY SIZE:
- Small (1.5 cu ft): 16 boxes
- Medium (3.0 cu ft): 28 boxes
- Large (4.5 cu ft): 12 boxes
- Specialty (wardrobe/dish): 2 boxes

BREAKDOWN BY ROOM:
- Bedroom: 18 boxes
- Kitchen: 10 boxes
- Living room: 14 boxes
- Bathroom: 3 boxes
- Storage/misc: 7 boxes

ESTIMATED VOLUME: 145 cubic feet
ESTIMATED WEIGHT: 1,015 lbs

RECOMMENDED TRUCK: 15-17 ft

SHOPPING LIST:
- 16 small boxes @ $1.50 = $24
- 28 medium boxes @ $2.00 = $56
- 12 large boxes @ $2.75 = $33
- Packing tape (4 rolls): $20
- Bubble wrap: $25
- Packing paper: $15

TOTAL ESTIMATED COST: $173

TIMELINE RECOMMENDATION:
- Week 1: Pack decor, books, seasonal items
- Week 2: Pack closet, storage areas
- Week 3: Pack living room, office area
- Week 4: Pack kitchen (except essentials), bedroom
================================
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
