---
name: move-out-fund-planner
version: 1.0.0
---

# Move Out Fund Planner - Initialization Guide

Calculate the exact dollar amount needed to safely leave your parents' house with comprehensive cost breakdowns, emergency fund sizing, location-aware pricing, and multi-scenario safety assessments.

## What This Skill Does

Helps young adults (and their parents) determine the precise savings needed before moving out, preventing premature moves that lead to financial instability. Covers:

- **Comprehensive cost calculation** - All upfront costs including often-forgotten utility deposits and household essentials
- **Location-aware pricing** - Adjusts for LCOL, MCOL, and HCOL areas
- **Living arrangement modeling** - Compares solo, shared, and studio options
- **Emergency fund sizing** - Based on job stability (3-6 months)
- **Timeline planning** - Month-by-month savings targets
- **Safety assessment** - 8-point risk evaluation before recommending a move

## Package Structure

```
move-out-fund-planner/
├── SKILL.md    # Main skill prompt (copy to your AI assistant)
└── INIT.md     # This initialization guide
```

## Files to Generate

None required - this is a prompt-only skill. The SKILL.md file contains the complete financial planning assistant instructions.

## Installation

### Claude Code / Claude Projects

```bash
# Copy skill folder to Claude skills directory
cp -r move-out-fund-planner/ ~/.claude/skills/move-out-fund-planner/
```

Then reference in your Claude project or conversation.

### ChatGPT / Custom GPTs

1. Open `SKILL.md` in a text editor
2. Copy all content after the `---` frontmatter section
3. Paste into ChatGPT's custom instructions or create a new Custom GPT
4. Use as system prompt for financial planning conversations

### Gemini / Other AI Assistants

1. Open `SKILL.md`
2. Copy the main prompt content
3. Paste at the start of your conversation or into assistant settings
4. The AI will adopt the Move Out Fund Planner role

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_monthly_rent}}` | `1200` | Target rent in your area (USD) |
| `{{monthly_net_income}}` | `2500` | Your take-home pay after taxes |
| `{{emergency_fund_months}}` | `3` | Months of expenses to save (3-6 based on job stability) |
| `{{living_arrangement_type}}` | `solo_apartment` | Options: solo_apartment, shared_2roommates, studio |
| `{{employment_stability}}` | `stable` | Options: stable, moderate, uncertain |
| `{{current_savings}}` | `0` | Amount you've already saved |

## Quick Start Prompts

After installing, try these prompts:

**Basic assessment:**
> I make $3,500/month after taxes and have $8,000 saved. Rent in my city is around $1,400/month. Can I afford to move out?

**Timeline planning:**
> I want to move out in 8 months. I can save $600/month and have $2,000 saved. What should I target?

**Scenario comparison:**
> Show me the cost difference between getting my own apartment vs. finding a roommate in Denver.

**Safety check:**
> My 24-year-old wants to move out with $5,000 saved and a new job. Is this safe?

**Cheapest option:**
> What's the minimum I need to safely move out if I'm willing to have roommates?

## Key Formulas Used

**Total Needed:**
```
Total = Move-Out Costs + Emergency Fund + 20% Buffer
```

**Move-Out Costs (typical):**
```
First month rent + Security deposit + Utility deposits ($200-600) + Moving ($100-500) + Household setup ($700-3000)
```

**Emergency Fund:**
```
Monthly Expenses × Stability Multiplier (3-6 months)
```

**Housing Affordability:**
```
Rent should be < 30% of gross monthly income
```

## Safety Assessment Checklist

The skill runs these 8 checks before recommending a move:

1. Emergency fund ≥ 3 months expenses?
2. Housing cost < 30% of income?
3. Total savings ≥ amount needed?
4. Job security matches emergency fund size?
5. $500+ buffer beyond emergency fund?
6. Debt payments manageable?
7. 6+ months at current job?
8. Location financially sustainable?

**Scoring:**
- 7-8 passed: LOW RISK - Safe to proceed
- 5-6 passed: MODERATE RISK - Proceed with caution
- 3-4 passed: HIGH RISK - Wait and save more
- 0-2 passed: NOT RECOMMENDED

## Common Adjustments

**For HCOL cities (NYC, SF, Boston):**
- Increase move-out cost estimates by 50-100%
- Budget for broker fees (1 month rent)
- Target 6 months emergency fund

**For safety-motivated moves:**
- Prioritize roommate options for faster timeline
- Research emergency housing resources
- Build larger emergency fund (limited family support)

**For gig workers / contract employees:**
- Use 6-month emergency fund minimum
- Add extra buffer for income volatility
- Consider roommates to reduce fixed costs

## Related Skills

- **Roommate Agreement Drafter** - Create contracts for shared living
- **Emergency Fund Calculator** - Detailed emergency fund sizing
- **Budget Planner** - Monthly budget creation and tracking
- **Moving Cost & Logistics Optimizer** - Moving day planning

---
Downloaded from [Find Skill.ai](https://findskill.ai)
