---
name: lease-break-negotiator
version: 1.0.0
---

# Lease Break Negotiator - Initialization

AI-powered assistant for negotiating early lease termination. Generates compelling reasons, financial proposals, and professional communication strategies to break residential or commercial leases while minimizing penalties and preserving landlord relationships.

## Package Structure

```
lease-break-negotiator/
├── SKILL.md    # Main skill prompt (copy to AI assistant)
└── INIT.md     # This initialization file
```

## Files Included

### SKILL.md
The complete lease break negotiation skill with:
- Reason validation and legal protection assessment
- Financial proposal calculations (5 scenarios)
- Negotiation strategy frameworks by landlord type
- Professional letter and proposal templates
- Subletting vs. assignment vs. buyout comparison
- State-specific compliance guidance
- Troubleshooting for common challenges

## Installation

### Claude Code (Claude Desktop / CLI)

```bash
# Create skills directory if needed
mkdir -p ~/.claude/skills

# Copy skill to Claude skills folder
cp -r lease-break-negotiator/ ~/.claude/skills/lease-break-negotiator/

# Verify installation
ls ~/.claude/skills/lease-break-negotiator/
```

### ChatGPT / Custom GPT

1. Open ChatGPT and create a new Custom GPT or edit an existing one
2. Go to "Configure" → "Instructions"
3. Open `SKILL.md` and copy ALL content after the frontmatter (after the second `---`)
4. Paste into the Instructions field
5. Save the GPT

### Claude.ai (Web)

1. Start a new conversation
2. Open `SKILL.md` and copy the content after the frontmatter
3. Paste as your first message with: "Use these instructions for our conversation:"
4. Proceed with your lease break questions

### Gemini

1. Open Google AI Studio or Gemini
2. Create a new prompt or conversation
3. Open `SKILL.md` and copy the content after the frontmatter
4. Paste as system instructions or first message
5. Proceed with your lease break questions

### Other AI Assistants

1. Open `SKILL.md` in any text editor
2. Copy all content after the second `---` line
3. Paste into your AI assistant's system prompt or instructions field
4. If no system prompt available, paste as first message

## Configuration Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{lease_type}}` | `residential` | Type of lease (residential or commercial) |
| `{{remaining_months}}` | `12` | Number of months remaining on lease |
| `{{monthly_rent}}` | `1500` | Current monthly rent in dollars |
| `{{termination_reason}}` | `job_relocation` | Primary reason for lease break |
| `{{jurisdiction}}` | `California` | State/region where property is located |
| `{{landlord_type}}` | `property_management` | Type of landlord entity |

### Termination Reason Options
- `job_relocation` - Job transfer or new employment in different location
- `medical_hardship` - Health condition requiring relocation
- `financial_difficulty` - Job loss, income reduction
- `landlord_breach` - Landlord violated lease terms
- `domestic_violence` - Safety-related relocation (legally protected)
- `military_deployment` - Active duty deployment (SCRA protected)
- `habitability` - Property health/safety violations

### Landlord Type Options
- `individual_owner` - Individual person who owns property
- `property_management` - Professional property management company
- `corporate` - Large corporate landlord entity

## Usage Examples

### Basic Lease Break Assessment
```
I'm renting in Seattle with 8 months left on my lease at $1,800/month.
I got a job offer in Portland starting in 45 days. The lease is with
a property management company. Help me plan my lease break.
```

### Military Deployment
```
I'm active duty military and just received PCS orders. My apartment
lease in Texas has 14 months remaining at $1,200/month. What are my
rights under SCRA and how do I notify my landlord?
```

### Subletting vs. Breaking Analysis
```
I need to relocate for a 6-month work assignment. My lease allows
subletting with landlord consent. Should I sublet or break the lease?
Monthly rent is $2,000 with 10 months remaining in California.
```

### Difficult Landlord Situation
```
My landlord is refusing to negotiate on my lease break despite my
documented medical condition. I've provided a doctor's note. The
property management company says "no exceptions." What are my options?
```

## Core Capabilities

1. **Reason Validation** - Categorizes termination reasons by legal protection level
2. **Financial Calculations** - Generates 5 proposal scenarios with cost comparisons
3. **Negotiation Strategy** - Custom frameworks for different landlord types
4. **Document Generation** - Professional termination letters and proposals
5. **Alternative Analysis** - Subletting vs. assignment vs. buyout comparison
6. **Compliance Check** - SCRA, domestic violence, habitability protections
7. **Troubleshooting** - Strategies for difficult landlord situations

## Integration with Other Skills

This skill works well with:
- **Lease Gotcha Scanner** - Review lease before planning termination
- **Sublet Vetting Protocol** - Screen replacement tenants if subletting
- **Security Deposit Reclaimer** - Maximize deposit return at move-out
- **Negotiation Stance Builder** - Strengthen overall negotiation position

## Support

For issues or questions about this skill:
- Visit [Find Skill.ai](https://findskill.ai)
- Check the skill page for updates
- Review related skills for complementary guidance

## Legal Disclaimer

This skill provides general guidance on lease termination negotiations. It is not legal advice. Users should:
- Verify all legal protections with current state/local law
- Consult with a licensed attorney for complex situations
- Review their specific lease agreement carefully
- Understand that outcomes depend on many factors

---

Downloaded from [Find Skill.ai](https://findskill.ai)
