---
name: first-apartment-essentials-list
version: 1.0.0
---

# Initialization

Generate prioritized shopping checklists for first-time renters moving into their first apartment. Creates budget-conscious recommendations organized by urgency (move-in day, first week, gradual purchases), provides specific shopping sources (dollar stores, thrift, marketplace), and guides security deposit documentation.

## Structure

- `SKILL.md` - Main skill prompt with comprehensive apartment setup guidance

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r first-apartment-essentials-list/ ~/.claude/skills/first-apartment-essentials-list/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# First Apartment Essentials List Generator")
3. Paste into AI assistant as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{apartment_size}}` | `1bed` | Size of apartment (studio, 1bed, 2bed, 3bed, 4bed+) |
| `{{budget_level}}` | `moderate` | Budget tier: minimal ($300-500), moderate ($800-1500), comfortable ($1500-3000), luxury ($3000+) |
| `{{lifestyle_type}}` | `working_professional` | User situation: student, working_professional, work_from_home, couple, young_family |
| `{{climate_zone}}` | `temperate` | Local climate: tropical, temperate, cold, seasonal_extreme |
| `{{living_situation}}` | `living_alone` | Household: living_alone, couple, roommates, with_children |
| `{{lease_duration}}` | `12_months` | Lease length: 6_months, 12_months, 24_months, indefinite |

## Example Usage

```
I'm a 24-year-old recent grad moving into my first studio apartment with a $600 budget. I have nothing from home - no furniture, no kitchen stuff, nothing. Create a prioritized checklist showing what I absolutely need before move-in day versus what can wait. Include specific dollar store recommendations and tell me what's worth buying used versus new. I want to be able to shower, sleep, and eat on day one without any emergencies.
```

## What This Skill Does

1. **Assesses your situation** - Asks about apartment size, budget, lifestyle, and timeline
2. **Creates prioritized checklists** - Organizes items by urgency: move-in day, first week, gradual
3. **Provides budget-specific recommendations** - Dollar store items, thrift finds, quality investments
4. **Guides documentation** - Photo/video protocols to protect your security deposit
5. **Warns about forgotten items** - The plunger, shower curtain, and other panic-inducing omissions

## Key Features

- **Budget tiers**: Minimal ($300-500), Moderate ($800-1500), Comfortable ($1500-3000)
- **Room-by-room checklists**: Bathroom, bedroom, kitchen, living area, cleaning, tools, safety
- **Shopping strategy**: Where to buy what (dollar store vs. thrift vs. quality investment)
- **First-Day Box concept**: 24-48 hour survival kit packed separately
- **Move-in timeline**: 2 weeks before, 1 week before, move-in day, first week, first month
- **Lifestyle modifications**: Students, WFH professionals, couples, pet owners

## The Universal Must-Haves

Items every experienced renter says to buy BEFORE move-in day:
1. Plunger (the #1 forgotten item)
2. Toilet paper (multiple rolls)
3. Shower curtain + rings + rod
4. Bath towels
5. Sheets and pillow
6. Extension cord and power strip
7. Flashlight
8. Basic cleaning supplies

---

Downloaded from [Find Skill.ai](https://findskill.ai)
