---
name: landlord-red-flag-identifier
version: 1.0.0
---

# Initialization

Landlord Red Flag Identifier - An AI skill that helps tenants evaluate rental listings, landlord behavior, lease terms, and property conditions to identify potential problems before signing a lease. It serves as a protective tool that systematically assesses rental agreements, landlord behavior patterns, and property conditions against established tenant protection standards and legal requirements.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive tenant protection instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r landlord-red-flag-identifier/ ~/.claude/skills/landlord-red-flag-identifier/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{jurisdiction_state}}` | `United States` | Your state/country for tenant law specifics |
| `{{rental_property_type}}` | `apartment` | Type of rental (apartment, house, condo, room) |
| `{{risk_tolerance_level}}` | `medium` | How cautious you want to be (low, medium, high) |
| `{{landlord_response_expectation_hours}}` | `48` | Expected response time from landlord |
| `{{max_acceptable_security_deposit_months}}` | `2` | Maximum deposit you consider reasonable |

## Core Capabilities

1. **Lease Term Analysis** - Flag problematic clauses, excessive fees, vague language, illegal provisions
2. **Landlord Red Flag Assessment** - Identify communication issues, responsiveness problems, maintenance neglect patterns
3. **Property Condition Evaluation** - Spot safety issues, maintenance problems, habitability violations
4. **Legal Compliance Check** - Identify violations of tenant rights, discrimination, retaliation clauses
5. **Lease Question Generator** - Suggest critical questions to ask landlords before signing
6. **Risk Scoring System** - Rate overall safety and fairness of rental opportunity
7. **Tenant Rights Education** - Explain relevant tenant protection laws by jurisdiction

## Example Usage

```
I'm looking at an Austin, TX apartment: $1,650/month rent, $3,300 security
deposit (2 months), $50 application fee, 12-month lease with $500 early
termination fee. The lease includes a clause saying 'Landlord may modify
any provision of this agreement at any time with 30 days notice' and late
fees of $75/day starting day 2. The landlord took 4 days to respond to my
initial inquiry and seemed rushed during the tour. Can you analyze this
for red flags?
```

## Research Sources

This skill was developed using authoritative sources including:
- Apartments.com lease agreement guides
- Legal resources on illegal landlord practices
- Tenant rights organizations
- Academic research on automated lease review
- State-specific tenant protection laws

---
Downloaded from [Find Skill.ai](https://findskill.ai)
