---
name: wellness-habit-builder
version: 1.0.0
---

# Wellness Habit Builder - Initialization

Design personalized habit stacks across sleep, exercise, nutrition, and mental health using behavioral science principles from Atomic Habits, Tiny Habits, and cutting-edge research.

## What This Skill Does

The Wellness Habit Builder helps you:

1. **Assess your current wellness baseline** across four interconnected domains (sleep, exercise, nutrition, mental health)
2. **Identify anchor habits** in your existing routine that can serve as triggers for new behaviors
3. **Design personalized habit stacks** using the "After [X], I will [Y]" formula
4. **Sequence habits by domain dependencies** so improvements in one area fuel gains in others
5. **Track and correlate** habit completion with outcomes to discover what works for you
6. **Adapt to motivation dips** with micro-challenges and appropriate gamification
7. **Generate healthcare summaries** for productive conversations with your doctor

## Structure

```
wellness-habit-builder/
├── SKILL.md      # Main skill prompt (comprehensive habit building system)
└── INIT.md       # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Initialization Steps

### For Claude Code Users

```bash
# Copy to Claude Code skills directory
cp -r wellness-habit-builder/ ~/.claude/skills/wellness-habit-builder/
```

### For ChatGPT, Gemini, Copilot, or Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "# Wellness Habit Builder")
3. Paste into your AI assistant as a system prompt or custom instruction
4. Begin your conversation with your wellness goals

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{primary_wellness_goal}}` | `improve sleep quality` | The main health outcome you want to achieve |
| `{{current_anchor_habits}}` | `morning coffee, evening dinner, brushing teeth` | Existing daily routines that can serve as triggers |
| `{{available_time_per_day}}` | `15` | Minutes available for new habits |
| `{{wearable_device}}` | `Apple Watch` | Health tracking device if any |
| `{{health_conditions}}` | `none` | Relevant health considerations |
| `{{neuroplasticity_preference}}` | `visual` | Preferred feedback modality (visual, numeric, social) |

## Quick Start Example

After installing the skill, try this prompt:

```
I sleep 5-6 hours nightly but need to be sharp for 10-hour workdays.
I work from home, exercise zero, eat inconsistent meals. My doctor
said my cortisol is elevated. Build me a 6-week habit stack that
prioritizes sleep first, then energy, without requiring gym membership
or meal prep. Start tiny—I'm skeptical but willing to try 5 min/day.
```

## Key Concepts to Know

- **Habit Stacking:** "After [anchor], I will [new habit]"
- **Tiny Habits:** Start with 2-3 minute behaviors (90%+ compliance)
- **Context > Motivation:** Same time + location + preceding action = faster automaticity
- **59-Day Median:** Habits take 4-12 weeks to become automatic (not 21 days)
- **Domain Integration:** Sleep → Exercise → Nutrition → Mental Health reinforce each other

## Research Foundation

This skill synthesizes research from:
- James Clear's *Atomic Habits*
- BJ Fogg's *Tiny Habits* and Stanford Behavior Design Lab
- JMIR systematic reviews on digital behavior change interventions (2024)
- PNAS machine learning studies on habit formation (2023)
- PLoS ONE research on context stability and automaticity (2022)

## Related Skills

- [Habit Stacking Architect](/skills/productivity/habit-stacking-architect/) - "After X, I will Y" design
- [Sleep Optimizer](/skills/productivity/sleep-optimizer/) - Personalized sleep recommendations
- [Stress Management](/skills/productivity/stress-management/) - Stress trigger identification
- [Mental Wellness Companion](/skills/productivity/mental-wellness-companion/) - CBT and emotional support
- [Workout Generator](/skills/productivity/workout-generator/) - Personalized exercise routines
- [Meal Planner](/skills/productivity/meal-planner/) - Weekly nutrition plans

---

Downloaded from [Find Skill.ai](https://findskill.ai)
